/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util.implementation;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import dev.latvian.mods.kubejs.event.KubeEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.events.BiomeSpawnsEventJS;
import net.liopyu.entityjs.util.EventHandlers;
import net.liopyu.entityjs.util.RegistryUtil;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public class EventBasedSpawnModifier
implements BiomeModifier {
    private final BiomeSpawnsEventJS event;

    public EventBasedSpawnModifier() {
        if (EventHandlers.biomeSpawns.hasListeners()) {
            this.event = new BiomeSpawnsEventJS();
            EventHandlers.biomeSpawns.post((KubeEvent)this.event);
        } else {
            this.event = null;
        }
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        MobSpawnSettingsBuilder spawnsBuilder = builder.getMobSpawnSettings();
        if (phase == BiomeModifier.Phase.ADD) {
            for (BiomeSpawn biomeSpawn : BaseLivingEntityBuilder.biomeSpawnList) {
                MobSpawnSettings.SpawnerData spawnerData2 = biomeSpawn.spawnerData().get();
                for (Either<ResourceLocation, TagKey<Biome>> either : biomeSpawn.biomes()) {
                    either.map(rl -> {
                        if (biome.is(rl)) {
                            spawnsBuilder.addSpawn(spawnerData.type.getCategory(), spawnerData2);
                        }
                        return rl;
                    }, tag -> {
                        if (biome.is(tag)) {
                            spawnsBuilder.addSpawn(spawnerData.type.getCategory(), spawnerData2);
                        }
                        return tag;
                    });
                }
            }
            if (this.event != null) {
                for (BiomeSpawnsEventJS.Addition addition : this.event.additions) {
                    for (Either either : addition.biomes()) {
                        either.map(rl -> {
                            if (biome.is(rl)) {
                                spawnsBuilder.addSpawn(addition.entityType().getCategory(), addition.spawnData());
                            }
                            return rl;
                        }, tag -> {
                            if (biome.is(tag)) {
                                spawnsBuilder.addSpawn(addition.entityType().getCategory(), addition.spawnData());
                            }
                            return tag;
                        });
                    }
                }
            }
        }
        if (this.event != null && phase == BiomeModifier.Phase.REMOVE) {
            for (BiomeSpawnsEventJS.Removal removal : this.event.removals) {
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                for (Either<ResourceLocation, TagKey<Biome>> either : removal.biomes()) {
                    either.map(rl -> {
                        if (biome.is(rl)) {
                            atomicBoolean.set(true);
                        }
                        return rl;
                    }, tag -> {
                        if (biome.is(tag)) {
                            atomicBoolean.set(true);
                        }
                        return tag;
                    });
                    if (!atomicBoolean.get()) continue;
                    break;
                }
                if (!atomicBoolean.get()) continue;
                EntityType<?> entityType = removal.entityType();
                spawnsBuilder.getSpawner(entityType.getCategory()).removeIf(spawnerData -> spawnerData.type == type);
            }
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)RegistryUtil.EVENT_SPAWN_MODIFIER.get();
    }

    public record BiomeSpawn(List<Either<ResourceLocation, TagKey<Biome>>> biomes, Supplier<MobSpawnSettings.SpawnerData> spawnerData) {
    }
}

