/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.blocks;

import com.davenonymous.bonsaitrees.blocks.BonsaiPotBlock;
import com.davenonymous.bonsaitrees.blocks.BonsaiPotBlockInventories;
import com.davenonymous.bonsaitrees.blocks.BonsaiPotBlockProduction;
import com.davenonymous.bonsaitrees.blocks.BonsaiPotScreen;
import com.davenonymous.bonsaitrees.datacomponents.RedstoneModeDataComponent;
import com.davenonymous.bonsaitrees.lib.BaseBlockEntity;
import com.davenonymous.bonsaitrees.lib.gui.RedstoneMode;
import com.davenonymous.bonsaitrees.setup.ModBlocks;
import com.davenonymous.bonsaitrees.setup.ModDataComponents;
import com.davenonymous.bonsaitrees.setup.cache.BonsaiCache;
import com.davenonymous.bonsaitrees.setup.cache.SoilCache;
import com.davenonymous.bonsaitrees.setup.data.BonsaiInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BonsaiPotBlockEntity
extends BaseBlockEntity {
    public BonsaiPotBlockInventories inventories;
    public BonsaiPotBlockProduction production;
    private boolean firstTick = true;
    private RedstoneMode redstoneMode = RedstoneMode.STOP_ON_POWER;

    public BonsaiPotBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlocks.BONSAI_POT_ENTITY.get(), pos, blockState);
        this.inventories = new BonsaiPotBlockInventories(this, this::onInventoryChange);
        this.production = new BonsaiPotBlockProduction(this);
    }

    private ItemStack tryInsert(ItemStack stack, ItemStackHandler handler) {
        if (stack.isEmpty()) {
            return stack;
        }
        if (handler.getStackInSlot(0).isEmpty() && handler.isItemValid(0, stack)) {
            ItemStack toInsert = stack.split(1);
            handler.setStackInSlot(0, toInsert);
            this.setChanged();
            this.notifyClients(false);
        }
        return stack;
    }

    public ItemStack onItemClicked(ItemStack stack, Player player, InteractionHand hand) {
        this.tryInsert(stack, this.inventories.soilInventory);
        this.tryInsert(stack, this.inventories.saplingInventory);
        return stack;
    }

    private void onInventoryChange(ItemStackHandler handler, int slot) {
        this.production.onInventoryChange(handler, slot);
        if (handler == this.inventories.saplingInventory) {
            this.level.getLightEngine().checkBlock(this.getBlockPos());
        }
        this.setChanged();
        if (handler != this.inventories.outputInventory) {
            this.requestModelDataUpdate();
        }
        this.notifyClients(false);
    }

    public void tick() {
        if (this.firstTick) {
            this.production.init();
            this.level.getLightEngine().checkBlock(this.getBlockPos());
            this.firstTick = false;
        }
        this.production.tick();
    }

    public float getTreeGrowthProgress(float partialTicks) {
        return this.production.getTreeGrowthProgress(partialTicks);
    }

    public BonsaiPotBlockEntity setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.setChanged();
        this.notifyClients(false);
        return this;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.inventories.applyImplicitComponents(componentInput);
        RedstoneModeDataComponent redstoneModeComponent = (RedstoneModeDataComponent)componentInput.get(ModDataComponents.REDSTONEMODE_COMPONENT);
        if (redstoneModeComponent != null) {
            this.redstoneMode = redstoneModeComponent.mode();
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        this.inventories.collectImplicitComponents(components);
        components.set(ModDataComponents.REDSTONEMODE_COMPONENT, (Object)new RedstoneModeDataComponent(this.redstoneMode));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.requestModelDataUpdate();
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof BonsaiPotScreen) {
                BonsaiPotScreen potScreen = (BonsaiPotScreen)screen;
                potScreen.fireDataUpdateEvent();
            }
            this.production.onInventoryChange(this.inventories.saplingInventory, 0);
            this.production.onInventoryChange(this.inventories.soilInventory, 0);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventories.deserializeNBT(registries, tag.getCompound("inv"));
        this.production.deserializeNBT(registries, tag.getCompound("production"));
        this.redstoneMode = RedstoneMode.byId(tag.getInt("redstoneMode"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inv", (Tag)this.inventories.serializeNBT(registries));
        tag.put("production", (Tag)this.production.serializeNBT(registries));
        tag.putInt("redstoneMode", this.redstoneMode.getId());
    }

    public static IItemHandler getCapability(Level level, BlockPos pos, BlockState state, BlockEntity entity, Direction side) {
        if (entity instanceof BonsaiPotBlockEntity) {
            BonsaiPotBlockEntity bonsaiPot = (BonsaiPotBlockEntity)entity;
            if (side == Direction.DOWN) {
                return bonsaiPot.inventories.noInsertOutputInventory;
            }
            return bonsaiPot.inventories.accessibleInventories;
        }
        return null;
    }

    public ModelData getModelData() {
        Item item;
        ItemStack camouflageStack;
        Item item2;
        ItemStack soilStack;
        ModelData.Builder modelData = ModelData.builder();
        ItemStack saplingStack = this.inventories.getSaplingStack();
        if (!saplingStack.isEmpty() && BonsaiCache.BONSAI_BY_ITEM.containsKey(saplingStack.getItem())) {
            BonsaiInfo info = BonsaiCache.BONSAI_BY_ITEM.get(saplingStack.getItem());
            modelData.with(BonsaiPotBlock.SAPLING, (Object)info.model());
        }
        if (!(soilStack = this.inventories.getSoilStack()).isEmpty() && (item2 = soilStack.getItem()) instanceof BlockItem) {
            BlockItem item3 = (BlockItem)item2;
            modelData.with(BonsaiPotBlock.SOIL, (Object)item3.getBlock());
        }
        if (!soilStack.isEmpty() && (item2 = soilStack.getItem()) instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item2;
            modelData.with(BonsaiPotBlock.FLUID_SOIL, (Object)bucket.content);
        }
        if (!soilStack.isEmpty() && SoilCache.SOIL_BY_ITEM.containsKey(soilStack.getItem())) {
            modelData.with(BonsaiPotBlock.ITEM_SOIL, (Object)soilStack.getItem());
        }
        if (!(camouflageStack = this.inventories.getCamouflageStack()).isEmpty() && (item = camouflageStack.getItem()) instanceof BlockItem) {
            BlockItem item4 = (BlockItem)item;
            modelData.with(BonsaiPotBlock.CAMOUFLAGE, (Object)item4.getBlock());
        }
        return modelData.build();
    }
}

