/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.blocks;

import com.davenonymous.bonsaitrees.blocks.BonsaiPotBlockEntity;
import com.davenonymous.bonsaitrees.datacomponents.CamouflageDataComponent;
import com.davenonymous.bonsaitrees.datacomponents.SaplingDataComponent;
import com.davenonymous.bonsaitrees.datacomponents.SoilDataComponent;
import com.davenonymous.bonsaitrees.datacomponents.ToolDataComponent;
import com.davenonymous.bonsaitrees.setup.ModDataComponents;
import com.davenonymous.bonsaitrees.setup.ModTags;
import com.davenonymous.bonsaitrees.setup.cache.BonsaiCache;
import com.davenonymous.bonsaitrees.setup.cache.SoilCache;
import com.davenonymous.bonsaitrees.setup.config.GameplayConfig;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.UnknownNullability;

public class BonsaiPotBlockInventories
implements INBTSerializable<CompoundTag> {
    public BonsaiPotBlockEntity potBlock;
    public ItemStackHandler saplingInventory;
    public ItemStackHandler soilInventory;
    public ItemStackHandler camouflageInventory;
    public ItemStackHandler toolInventory;
    public ItemStackHandler outputInventory;
    public CombinedInvWrapper noInsertOutputInventory;
    public CombinedInvWrapper accessibleInventories;
    public ItemEnchantments enchantments;
    private final BiConsumer<ItemStackHandler, Integer> onChangeHandler;

    public BonsaiPotBlockInventories(BonsaiPotBlockEntity potBlock, BiConsumer<ItemStackHandler, Integer> onChangeHandler) {
        this.potBlock = potBlock;
        this.saplingInventory = this.createSaplingInventory();
        this.soilInventory = this.createSoilInventory();
        this.camouflageInventory = this.createCamouflageInventory();
        this.toolInventory = this.createToolInventory();
        this.outputInventory = this.createOutputInventory();
        this.noInsertOutputInventory = this.createNoInsertOutputInventory();
        this.accessibleInventories = this.createCombinedInventory();
        this.onChangeHandler = onChangeHandler;
        this.enchantments = ItemEnchantments.EMPTY;
    }

    public BonsaiPotBlockInventories setSaplingStack(Block block) {
        return this.setSaplingStack(new ItemStack((ItemLike)block));
    }

    public BonsaiPotBlockInventories setSaplingStack(ItemStack stack) {
        this.saplingInventory.setStackInSlot(0, stack);
        return this;
    }

    public BonsaiPotBlockInventories setSoilStack(Block block) {
        return this.setSoilStack(new ItemStack((ItemLike)block));
    }

    public BonsaiPotBlockInventories setSoilStack(ItemStack stack) {
        this.soilInventory.setStackInSlot(0, stack);
        return this;
    }

    public BonsaiPotBlockInventories setCamouflageStack(Block block) {
        return this.setCamouflageStack(new ItemStack((ItemLike)block));
    }

    public BonsaiPotBlockInventories setCamouflageStack(ItemStack stack) {
        this.camouflageInventory.setStackInSlot(0, stack);
        return this;
    }

    public BonsaiPotBlockInventories setToolStack(ItemStack stack) {
        this.toolInventory.setStackInSlot(0, stack);
        return this;
    }

    public ItemStack getSaplingStack() {
        return this.saplingInventory.getStackInSlot(0);
    }

    public ItemStack getSoilStack() {
        return this.soilInventory.getStackInSlot(0);
    }

    public ItemStack getCamouflageStack() {
        return this.camouflageInventory.getStackInSlot(0);
    }

    public ItemStack getToolStack() {
        return this.toolInventory.getStackInSlot(0);
    }

    private CombinedInvWrapper createNoInsertOutputInventory() {
        return new CombinedInvWrapper(this, new IItemHandlerModifiable[]{this.outputInventory}){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return stack;
            }
        };
    }

    private CombinedInvWrapper createCombinedInventory() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.toolInventory, this.soilInventory, this.saplingInventory});
    }

    private ItemStackHandler createToolInventory() {
        final Set<ItemAbility> BONSAI_ACTIONS = Set.of(ItemAbilities.AXE_DIG, ItemAbilities.SHEARS_DIG, ItemAbilities.SHEARS_HARVEST, ItemAbilities.SWORD_DIG, ItemAbilities.SHOVEL_DIG, ItemAbilities.PICKAXE_DIG);
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                BonsaiPotBlockInventories.this.onChangeHandler.accept(this, slot);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isItemValid(int slot, ItemStack stack) {
                boolean isValid = stack.has(DataComponents.TOOL);
                boolean configAllowed = GameplayConfig.toolAllowIndestructible || stack.isDamageableItem();
                if (!isValid) return false;
                if (!configAllowed) return false;
                if (!BONSAI_ACTIONS.stream().anyMatch(arg_0 -> ((ItemStack)stack).canPerformAction(arg_0))) return false;
                return true;
            }
        };
    }

    private ItemStackHandler createOutputInventory() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                BonsaiPotBlockInventories.this.onChangeHandler.accept(this, slot);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return true;
            }
        };
    }

    private ItemStackHandler createSaplingInventory() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                BonsaiPotBlockInventories.this.onChangeHandler.accept(this, slot);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected int getStackLimit(int slot, ItemStack stack) {
                return 1;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return BonsaiCache.BONSAI_BY_ITEM.containsKey(stack.getItem());
            }
        };
    }

    private ItemStackHandler createSoilInventory() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                BonsaiPotBlockInventories.this.onChangeHandler.accept(this, slot);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected int getStackLimit(int slot, ItemStack stack) {
                return 1;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return SoilCache.isSoil(stack);
            }
        };
    }

    private ItemStackHandler createCamouflageInventory() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                BonsaiPotBlockInventories.this.onChangeHandler.accept(this, slot);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected int getStackLimit(int slot, ItemStack stack) {
                return 1;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                Item item = stack.getItem();
                if (item instanceof BlockItem) {
                    BlockItem item2 = (BlockItem)item;
                    Block block = item2.getBlock();
                    BlockState state = block.defaultBlockState();
                    boolean isBlocked = state.is(ModTags.NO_CAMOUFLAGE);
                    if (isBlocked) {
                        return false;
                    }
                    boolean isSolid = state.isSolidRender((BlockGetter)BonsaiPotBlockInventories.this.potBlock.getLevel(), BonsaiPotBlockInventories.this.potBlock.getBlockPos());
                    boolean isFullCollision = state.isCollisionShapeFullBlock((BlockGetter)BonsaiPotBlockInventories.this.potBlock.getLevel(), BonsaiPotBlockInventories.this.potBlock.getBlockPos());
                    return isSolid && isFullCollision;
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        ItemEnchantments itemEnchantments;
        Object object;
        Record saplingDataComponent;
        Object soil;
        ResourceLocation resourceLocation;
        Record record;
        Object object2 = componentInput.get(ModDataComponents.CAMOUFLAGE_COMPONENT);
        if (object2 instanceof CamouflageDataComponent) {
            ResourceLocation camouflage;
            record = (CamouflageDataComponent)object2;
            try {
                camouflage = resourceLocation = ((CamouflageDataComponent)record).camouflage();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Block camouflageBlock = (Block)BuiltInRegistries.BLOCK.get(camouflage);
            this.setCamouflageStack(camouflageBlock);
        }
        if ((object2 = componentInput.get(ModDataComponents.SOIL_COMPONENT)) instanceof SoilDataComponent) {
            record = (SoilDataComponent)object2;
            {
                resourceLocation = ((SoilDataComponent)record).soil();
                soil = resourceLocation;
                this.setSoilStack(soil.copy());
            }
        }
        if ((soil = componentInput.get(ModDataComponents.SAPLING_COMPONENT)) instanceof SaplingDataComponent) {
            saplingDataComponent = (SaplingDataComponent)soil;
            if (BuiltInRegistries.BLOCK.containsKey(((SaplingDataComponent)saplingDataComponent).sapling())) {
                Block saplingBlock = (Block)BuiltInRegistries.BLOCK.get(((SaplingDataComponent)saplingDataComponent).sapling());
                this.setSaplingStack(saplingBlock);
            } else if (BuiltInRegistries.ITEM.containsKey(((SaplingDataComponent)saplingDataComponent).sapling())) {
                this.setSaplingStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(((SaplingDataComponent)saplingDataComponent).sapling())));
            }
        }
        if ((object2 = componentInput.get(ModDataComponents.TOOL_COMPONENT)) instanceof ToolDataComponent) {
            saplingDataComponent = (ToolDataComponent)object2;
            {
                ResourceLocation tool = resourceLocation = ((ToolDataComponent)saplingDataComponent).tool();
                this.setToolStack(tool.copy());
            }
        }
        if (!((object = componentInput.get(DataComponents.ENCHANTMENTS)) instanceof ItemEnchantments)) return;
        this.enchantments = itemEnchantments = (ItemEnchantments)object;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        ItemStack tool;
        Item item;
        ItemStack camouflage;
        ItemStack sapling;
        ItemStack soil = this.getSoilStack();
        if (!soil.isEmpty()) {
            components.set(ModDataComponents.SOIL_COMPONENT, (Object)new SoilDataComponent(soil.copy()));
        }
        if (!(sapling = this.getSaplingStack()).isEmpty()) {
            components.set(ModDataComponents.SAPLING_COMPONENT, (Object)new SaplingDataComponent(sapling.getItem().builtInRegistryHolder().getKey().location(), Optional.of(Float.valueOf(1.0f))));
        }
        if (!(camouflage = this.getCamouflageStack()).isEmpty() && (item = camouflage.getItem()) instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            components.set(ModDataComponents.CAMOUFLAGE_COMPONENT, (Object)new CamouflageDataComponent(item2.getBlock().builtInRegistryHolder().getKey().location()));
        }
        if (!(tool = this.getToolStack()).isEmpty()) {
            components.set(ModDataComponents.TOOL_COMPONENT, (Object)new ToolDataComponent(tool.copy()));
        }
        if (!this.enchantments.isEmpty()) {
            components.set(DataComponents.ENCHANTMENTS, (Object)this.enchantments);
        }
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.put("sapling", (Tag)this.saplingInventory.serializeNBT(registries));
        tag.put("soil", (Tag)this.soilInventory.serializeNBT(registries));
        tag.put("camouflage", (Tag)this.camouflageInventory.serializeNBT(registries));
        tag.put("tool", (Tag)this.toolInventory.serializeNBT(registries));
        tag.put("output", (Tag)this.outputInventory.serializeNBT(registries));
        if (!this.enchantments.isEmpty()) {
            CompoundTag enchantmentTag = new CompoundTag();
            this.enchantments.keySet().forEach(holder -> {
                int level = this.enchantments.getLevel(holder);
                ResourceKey key = holder.getKey();
                enchantmentTag.putInt(key.location().toString(), level);
            });
            tag.put("enchantments", (Tag)enchantmentTag);
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag tag) {
        this.saplingInventory.deserializeNBT(registries, tag.getCompound("sapling"));
        this.soilInventory.deserializeNBT(registries, tag.getCompound("soil"));
        this.camouflageInventory.deserializeNBT(registries, tag.getCompound("camouflage"));
        this.toolInventory.deserializeNBT(registries, tag.getCompound("tool"));
        this.outputInventory.deserializeNBT(registries, tag.getCompound("output"));
        if (tag.contains("enchantments")) {
            CompoundTag enchantmentTag = tag.getCompound("enchantments");
            HolderLookup.RegistryLookup registry = registries.lookupOrThrow(Registries.ENCHANTMENT);
            ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            for (String key : enchantmentTag.getAllKeys()) {
                Optional enchantment = registry.get(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)key)));
                if (!enchantment.isPresent()) continue;
                int level = enchantmentTag.getInt(key);
                enchantments.set(((Holder.Reference)enchantment.get()).getDelegate(), level);
            }
            this.enchantments = enchantments.toImmutable();
        }
    }
}

