/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui;

import com.davenonymous.bonsaitrees.lib.gui.GUI;
import com.davenonymous.bonsaitrees.lib.gui.event.CharTypedEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.KeyPressedEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.KeyReleasedEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.MouseClickEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.MouseDraggedEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.MouseMoveEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.MouseReleasedEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.MouseScrollEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.UpdateScreenEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.WidgetEventResult;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class WidgetScreen
extends Screen {
    protected GUI gui;
    private int previousMouseX = Integer.MAX_VALUE;
    private int previousMouseY = Integer.MAX_VALUE;
    private float partialTicks = 0.0f;
    protected ResourceLocation id;

    protected WidgetScreen(Component title) {
        super(title);
    }

    protected abstract GUI createGUI();

    public GUI getOrCreateGui() {
        if (this.gui == null) {
            this.gui = this.createGUI();
            this.gui.setVisible(true);
        }
        return this.gui;
    }

    public int mouseX() {
        return this.previousMouseX;
    }

    public int mouseY() {
        return this.previousMouseY;
    }

    public float partialTicks() {
        return this.partialTicks;
    }

    public void tick() {
        super.tick();
        this.getOrCreateGui().fireEvent(new UpdateScreenEvent());
        this.resetMousePositions();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.getOrCreateGui().fireEvent(new MouseClickEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.getOrCreateGui().fireEvent(new MouseReleasedEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseReleased(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        GUI gui = this.getOrCreateGui();
        gui.keyUp(scanCode);
        if (this.getOrCreateGui().fireEvent(new KeyReleasedEvent(keyCode, scanCode, modifiers)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.keyReleased(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean charTyped(char chr, int code) {
        if (this.getOrCreateGui().fireEvent(new CharTypedEvent(chr, code)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.charTyped(chr, code);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        GUI gui = this.getOrCreateGui();
        gui.keyDown(scanCode);
        if (gui.fireEvent(new KeyPressedEvent(keyCode, scanCode, modifiers)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.getOrCreateGui().fireEvent(new MouseDraggedEvent(mouseX, mouseY, button, dragX, dragY)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.getOrCreateGui().fireEvent(new MouseScrollEvent(mouseX, mouseY, scrollY)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return false;
    }

    public void render(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (mouseX != this.previousMouseX || mouseY != this.previousMouseY) {
            this.getOrCreateGui().fireEvent(new MouseMoveEvent(mouseX, mouseY));
            this.previousMouseX = mouseX;
            this.previousMouseY = mouseY;
        }
        this.partialTicks = partialTicks;
        this.getOrCreateGui().drawGUI(pGuiGraphics, this);
        this.getOrCreateGui().drawTooltips(pGuiGraphics, this, mouseX, mouseY);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void resetMousePositions() {
        this.previousMouseX = Integer.MIN_VALUE;
        this.previousMouseY = Integer.MIN_VALUE;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        super.onClose();
    }
}

