/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui.tooltip;

import com.davenonymous.bonsaitrees.lib.gui.tooltip.SerializableTooltipComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record StringTooltipComponent(String message, int color) implements SerializableTooltipComponent<StringTooltipComponent>
{
    public static final StreamCodec<FriendlyByteBuf, StringTooltipComponent> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, StringTooltipComponent::message, (StreamCodec)ByteBufCodecs.INT, StringTooltipComponent::color, StringTooltipComponent::new);

    public static final StringTooltipComponent white(String message) {
        return new StringTooltipComponent(message, ChatFormatting.WHITE.getColor());
    }

    public static final StringTooltipComponent gray(String message) {
        return new StringTooltipComponent(message, ChatFormatting.GRAY.getColor());
    }

    public static final StringTooltipComponent warn(String message) {
        return new StringTooltipComponent(message, -4896953);
    }

    public int getHeight() {
        return 10;
    }

    public int getWidth(Font font) {
        return font.width(this.message);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.drawString(font, this.message, x, y, this.color);
    }

    @Override
    public StreamCodec<FriendlyByteBuf, StringTooltipComponent> getCodec() {
        return CODEC;
    }
}

