/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import rearth.oritech.Oritech;

public class TagUtils {
    public static String C_TAG_NAMESPACE = "c";

    public static TagKey<Item> getStorageBlockTag(String path) {
        return TagUtils.cItemTag("storage_blocks/" + path);
    }

    public static TagKey<Block> getStorageBlockyTag(String path) {
        return TagUtils.cBlockTag("storage_blocks/" + path);
    }

    public static TagKey<Item> getIngotTag(String path) {
        return TagUtils.cItemTag("ingots/" + path);
    }

    public static TagKey<Item> getClumpTag(String path) {
        return TagUtils.cItemTag("clumps/" + path);
    }

    public static TagKey<Item> getDustTag(String path) {
        return TagUtils.cItemTag("dusts/" + path);
    }

    public static TagKey<Item> itemTag(String namespace, String path) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public static TagKey<Item> cItemTag(String path) {
        return TagUtils.itemTag(C_TAG_NAMESPACE, path);
    }

    public static TagKey<Block> cBlockTag(String path) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)C_TAG_NAMESPACE, (String)path));
    }

    public static TagKey<Item> oritechItemTag(String path) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Oritech.id(path));
    }

    public static TagKey<Block> oritechBlockTag(String path) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Oritech.id(path));
    }

    public static TagKey<Fluid> cFluidTag(String path) {
        return TagUtils.fluidTag(C_TAG_NAMESPACE, path);
    }

    public static TagKey<Fluid> fluidTag(String namespace, String path) {
        return TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public static TagKey<Fluid> oritechFluidTag(String path) {
        return TagUtils.fluidTag("oritech", path);
    }
}

