/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.pmapi.menu.providers;

import dev.ftb.mods.pmapi.PauseMenuMod;
import dev.ftb.mods.pmapi.api.menu.MenuLocation;
import dev.ftb.mods.pmapi.api.menu.PauseItemProvider;
import dev.ftb.mods.pmapi.api.menu.ScreenHolder;
import dev.ftb.mods.pmapi.api.menu.ScreenWidgetCollection;
import dev.ftb.mods.pmapi.api.widgets.IconButton;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class SupportPauseItemProvider
implements PauseItemProvider {
    private static final ResourceLocation DISCORD_ICON = ResourceLocation.fromNamespaceAndPath((String)"ftbpmapi", (String)"textures/gui/discord.png");
    private static final ResourceLocation GITHUB_ICON = ResourceLocation.fromNamespaceAndPath((String)"ftbpmapi", (String)"textures/gui/github.png");

    @Override
    @Nullable
    public ScreenWidgetCollection init(MenuLocation target, ScreenHolder screen, int x, int y) {
        ScreenWidgetCollection screenWidgetCollection = ScreenWidgetCollection.create();
        String githubUrl = (String)PauseMenuMod.config().githubLink.get();
        String discordUrl = (String)PauseMenuMod.config().discordLink.get();
        int xOffset = x;
        if (!discordUrl.isEmpty()) {
            screenWidgetCollection.addRenderableWidget(new IconButton(xOffset, y, 20, 20, DISCORD_ICON, (Component)Component.translatable((String)"ftbpmapi.tooltip.support_discord"), button -> Util.getPlatform().openUri(discordUrl), Supplier::get));
            xOffset += 24;
        }
        if (!githubUrl.isEmpty()) {
            screenWidgetCollection.addRenderableWidget(new IconButton(xOffset, y, 20, 20, GITHUB_ICON, (Component)Component.translatable((String)"ftbpmapi.tooltip.support_github"), button -> Util.getPlatform().openUri(githubUrl), Supplier::get));
        }
        return screenWidgetCollection;
    }

    @Override
    public int width() {
        if (((String)PauseMenuMod.config().githubLink.get()).isEmpty() || ((String)PauseMenuMod.config().discordLink.get()).isEmpty()) {
            return 20;
        }
        return 44;
    }

    @Override
    public int height() {
        return 20;
    }

    @Override
    public boolean disabled() {
        return ((String)PauseMenuMod.config().githubLink.get()).isEmpty() && ((String)PauseMenuMod.config().discordLink.get()).isEmpty();
    }
}

