/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.IconButton;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ButtonToolTips;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.client.ExSemantics;
import com.glodblock.github.extendedae.client.button.ActionEPPButton;
import com.glodblock.github.extendedae.container.ContainerExInterface;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.CUpdatePage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GuiExInterface
extends UpgradeableScreen<ContainerExInterface> {
    private final SettingToggleButton<FuzzyMode> fuzzyMode;
    private final List<Button> amountButtons = new ArrayList<Button>();
    private final ActionEPPButton nextPage;
    private final ActionEPPButton prePage;

    public GuiExInterface(ContainerExInterface menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.fuzzyMode = new ServerSettingToggleButton(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.nextPage = new ActionEPPButton(b -> EAENetworkHandler.INSTANCE.sendToServer(new CUpdatePage(1)), Icon.ARROW_RIGHT);
        this.prePage = new ActionEPPButton(b -> EAENetworkHandler.INSTANCE.sendToServer(new CUpdatePage(0)), Icon.ARROW_LEFT);
        this.nextPage.setMessage((Component)Component.translatable((String)"gui.extendedae.ex_interface.next"));
        this.prePage.setMessage((Component)Component.translatable((String)"gui.extendedae.ex_interface.pre"));
        this.addToLeftToolbar((Button)this.fuzzyMode);
        this.addToLeftToolbar((Button)this.nextPage);
        this.addToLeftToolbar((Button)this.prePage);
        this.widgets.addOpenPriorityButton();
        List configSlots = menu.getSlots(ExSemantics.EX_1);
        configSlots.addAll(menu.getSlots(ExSemantics.EX_3));
        configSlots.addAll(menu.getSlots(ExSemantics.EX_5));
        configSlots.addAll(menu.getSlots(ExSemantics.EX_7));
        for (int i = 0; i < configSlots.size(); ++i) {
            SetAmountButton button = new SetAmountButton(btn -> {
                int idx = this.amountButtons.indexOf(btn);
                Slot configSlot = (Slot)configSlots.get(idx);
                menu.openSetAmountMenu(configSlot.getSlotIndex());
            });
            button.setDisableBackground(true);
            button.setMessage((Component)ButtonToolTips.InterfaceSetStockAmount.text());
            this.widgets.add("amtButton" + (1 + i), (AbstractWidget)button);
            this.amountButtons.add((Button)button);
        }
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.extendedae.ex_interface.config", (Object[])new Object[]{((ContainerExInterface)this.menu).page + 1}), 8, 24, this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB(), false);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.fuzzyMode.set((Enum)((ContainerExInterface)this.menu).getFuzzyMode());
        this.fuzzyMode.setVisibility(((ContainerExInterface)this.menu).hasUpgrade((ItemLike)AEItems.FUZZY_CARD));
        ((ContainerExInterface)this.menu).showPage(((ContainerExInterface)this.menu).page);
        this.amountButtons.forEach(s -> {
            s.visible = false;
        });
        if (((ContainerExInterface)this.menu).page == 0) {
            this.nextPage.setVisibility(true);
            this.prePage.setVisibility(false);
        } else {
            this.prePage.setVisibility(true);
            this.nextPage.setVisibility(false);
        }
        for (int i = 0; i < 18; ++i) {
            Button button = this.amountButtons.get(i + ((ContainerExInterface)this.menu).page * 18);
            ItemStack item = ((ContainerExInterface)this.menu).getConfigSlots().get(i + ((ContainerExInterface)this.menu).page * 18).getItem();
            button.visible = !item.isEmpty();
        }
    }

    static class SetAmountButton
    extends IconButton {
        public SetAmountButton(Button.OnPress onPress) {
            super(onPress);
        }

        protected Icon getIcon() {
            return this.isHoveredOrFocused() ? Icon.COG : Icon.COG_DISABLED;
        }
    }
}

