/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.transporter;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.transporter.FilteredTransporterType;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.buuz135.industrial.block.transportstorage.transporter.filter.ItemFilter;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.buuz135.industrial.proxy.client.render.TransporterTESR;
import com.buuz135.industrial.utils.IndustrialTags;
import com.google.common.collect.Sets;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class TransporterItemType
extends FilteredTransporterType<ItemStack, IItemHandler> {
    public static final int QUEUE_SIZE = 6;
    private final HashMap<Direction, List<ItemStack>> queue = new HashMap();
    private int extractSlot = 0;

    public TransporterItemType(IBlockContainer<?> container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        super(container, factory, side, action);
        for (Direction value : Direction.values()) {
            while (this.queue.computeIfAbsent(value, direction -> new ArrayList()).size() < 6) {
                this.queue.get(value).addFirst(ItemStack.EMPTY);
            }
            if (this.queue.size() <= 6) continue;
            this.queue.get(value).removeLast();
        }
    }

    @Override
    public RegulatorFilter<ItemStack, IItemHandler> createFilter() {
        return new ItemFilter(20, 20, 5, 3, 16, 64, 8192, "");
    }

    @Override
    public void update() {
        super.update();
        float speed = this.getSpeed();
        if (this.getLevel().isClientSide || (float)this.getLevel().getGameTime() % Math.max(1.0f, 4.0f - speed) != 0.0f) {
            return;
        }
        IBlockContainer container = this.getContainer();
        if (this.getAction() != TransporterTypeFactory.TransporterAction.EXTRACT || !(container instanceof TransporterTile)) {
            return;
        }
        TransporterTile transporterTile = (TransporterTile)container;
        for (Direction direction : transporterTile.getTransporterTypeMap().keySet()) {
            IItemHandler destination;
            IItemHandler origin;
            TransporterType transporterType = transporterTile.getTransporterTypeMap().get(direction);
            if (!(transporterType instanceof TransporterItemType)) continue;
            TransporterItemType itemTransporter = (TransporterItemType)transporterType;
            if (transporterType.getAction() != TransporterTypeFactory.TransporterAction.INSERT || (origin = (IItemHandler)this.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, this.getPos().relative(this.getSide()), (Object)this.getSide().getOpposite())) == null || (destination = (IItemHandler)this.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, this.getPos().relative(direction), (Object)direction.getOpposite())) == null) continue;
            if (this.extractSlot >= origin.getSlots() || origin.getStackInSlot(this.extractSlot).isEmpty() || !this.getFilter().canExtract(origin.getStackInSlot(this.extractSlot), origin) || !itemTransporter.getFilter().canInsert(origin.getStackInSlot(this.extractSlot), destination)) {
                this.findSlot(origin, destination, itemTransporter);
            }
            if (this.extractSlot >= origin.getSlots()) {
                return;
            }
            if (origin.getStackInSlot(this.extractSlot).isEmpty()) {
                container.requestSync();
                continue;
            }
            int amount = (int)Math.ceil(1.0f * this.getEfficiency());
            ItemStack extracted = origin.extractItem(this.extractSlot, amount, true);
            int simulatedAmount = Math.min(this.getFilter().getExtractAmount(extracted, origin), itemTransporter.getFilter().getInsertAmount(extracted, destination));
            simulatedAmount = Math.min(amount, simulatedAmount);
            if (!extracted.isEmpty() && simulatedAmount > 0) {
                ItemStack returned = ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)extracted, (boolean)true);
                if (returned.isEmpty() || amount - returned.getCount() > 0) {
                    extracted = origin.extractItem(this.extractSlot, returned.isEmpty() ? simulatedAmount : simulatedAmount - returned.getCount(), false);
                    ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)extracted, (boolean)false);
                    itemTransporter.addTransferedStack(this.getSide(), extracted);
                } else {
                    ++this.extractSlot;
                    if (this.extractSlot >= origin.getSlots()) {
                        this.extractSlot = 0;
                    }
                }
            }
            container.requestSync();
        }
    }

    @Override
    public void updateClient() {
        super.updateClient();
        for (Direction value : Direction.values()) {
            while (this.queue.computeIfAbsent(value, direction -> new ArrayList()).size() < 6) {
                this.queue.get(value).addFirst(ItemStack.EMPTY);
            }
            this.queue.get(value).addFirst(ItemStack.EMPTY);
            while (this.queue.get(value).size() > 6) {
                this.queue.get(value).removeLast();
            }
        }
    }

    private void findSlot(@NotNull IItemHandler origin, IItemHandler destination, TransporterItemType otherTile) {
        for (int i = this.extractSlot; i < origin.getSlots(); ++i) {
            if (origin.getStackInSlot(i).isEmpty() || !this.getFilter().canExtract(origin.getStackInSlot(i), origin) || !otherTile.getFilter().canInsert(origin.getStackInSlot(i), destination)) continue;
            this.extractSlot = i;
            return;
        }
        this.extractSlot = 0;
    }

    public void addTransferedStack(Direction direction, @NotNull ItemStack stack) {
        this.syncRender(direction, (CompoundTag)stack.saveOptional((HolderLookup.Provider)this.getLevel().registryAccess()));
    }

    @Override
    public void handleRenderSync(Direction origin, CompoundTag compoundNBT) {
        this.queue.computeIfAbsent(origin, direction -> new ArrayList()).addFirst(ItemStack.parseOptional((HolderLookup.Provider)this.getLevel().registryAccess(), (CompoundTag)compoundNBT));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTransfer(Vector3f pos, Direction direction, int step, PoseStack stack, int combinedOverlayIn, MultiBufferSource buffer, float frame, Level level) {
        super.renderTransfer(pos, direction, step, stack, combinedOverlayIn, buffer, frame, level);
        if (step < this.queue.computeIfAbsent(direction, v -> new ArrayList()).size()) {
            float scale = 0.1f;
            stack.scale(scale, scale, scale);
            ItemStack itemStack = this.queue.get(direction).get(step);
            if (!itemStack.isEmpty()) {
                Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.NONE, 0xF000F0, combinedOverlayIn, stack, buffer, level, 0);
            } else {
                stack.pushPose();
                stack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
                stack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                VertexConsumer buffer1 = buffer.getBuffer(TransporterTESR.TYPE);
                float pX1 = 1.0f;
                float u = 1.0f;
                float pX2 = 0.0f;
                float u2 = 0.0f;
                Color CLOSE = Color.CYAN;
                Color FAR = new Color(6815999);
                double ratio = ((double)step + 2.5) / 6.0;
                float xOffset = -0.75f;
                float yOffset = -0.0f;
                float zOffset = -0.75f;
                boolean alpha = true;
                stack.scale(0.25f, 0.25f, 0.25f);
                float red = (float)((int)Math.abs(ratio * (double)FAR.getRed() + (1.0 - ratio) * (double)CLOSE.getRed())) / 256.0f;
                float green = (float)((int)Math.abs(ratio * (double)FAR.getGreen() + (1.0 - ratio) * (double)CLOSE.getGreen())) / 256.0f;
                float blue = (float)((int)Math.abs(ratio * (double)FAR.getBlue() + (1.0 - ratio) * (double)CLOSE.getBlue())) / 256.0f;
                Matrix4f matrix = stack.last().pose();
                buffer1.addVertex(matrix, pX2 + xOffset, yOffset, 0.0f + zOffset).setColor(red, green, blue, (float)alpha).setUv(u2, 0.0f);
                buffer1.addVertex(matrix, pX1 + xOffset + 0.5f, yOffset, 0.0f + zOffset).setColor(red, green, blue, (float)alpha).setUv(u, 0.0f);
                buffer1.addVertex(matrix, pX1 + xOffset + 0.5f, yOffset, 1.5f + zOffset).setColor(red, green, blue, (float)alpha).setUv(u, 1.0f);
                buffer1.addVertex(matrix, pX2 + xOffset, yOffset, 1.5f + zOffset).setColor(red, green, blue, (float)alpha).setUv(u2, 1.0f);
                stack.popPose();
            }
        }
    }

    public static class Factory
    extends TransporterTypeFactory {
        public Factory() {
            super("item");
        }

        @Override
        public TransporterType create(IBlockContainer container, Direction face, TransporterTypeFactory.TransporterAction action) {
            return new TransporterItemType(container, (TransporterTypeFactory)this, face, action);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, TransporterTypeFactory.TransporterAction action) {
            return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("block/transporters/item_transporter_" + action.name().toLowerCase() + "_" + upgradeSide.getSerializedName().toLowerCase()));
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Sets.newHashSet((Object[])new ResourceLocation[]{ResourceLocation.parse((String)"industrialforegoing:block/transporters/item"), ResourceLocation.parse((String)"industrialforegoing:block/base/bottom")});
        }

        @Override
        public boolean canBeAttachedAgainst(Level world, BlockPos pos, Direction face) {
            return world.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)face) != null;
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("block/transporters/item_transporter_" + TransporterTypeFactory.TransporterAction.EXTRACT.name().toLowerCase() + "_" + Direction.NORTH.getSerializedName().toLowerCase()));
        }

        public void registerRecipe(RecipeOutput consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem(), (int)2).pattern("IPI").pattern("GMG").pattern("ICI").define(Character.valueOf('I'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('P'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_PITY).define(Character.valueOf('C'), (ItemLike)Items.PISTON).save(consumer);
        }
    }
}

