/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.repository;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.rocketplatform.game.client.mod.ui.repository.LayoutParser;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import org.jetbrains.annotations.Nullable;

public class LayoutRepository {
    private final Map<String, LayoutTemplate> layouts = new HashMap<String, LayoutTemplate>();

    @Nullable
    public LayoutTemplate getLayout(String id) {
        return this.layouts.get(id);
    }

    public void addLayout(LayoutTemplate layout) {
        if (this.layouts.containsKey(layout.getId())) {
            throw new IllegalArgumentException("Layout with id " + layout.getId() + " already exists!");
        }
        this.layouts.put(layout.getId(), layout);
    }

    public void loadLayout(InputStream stream) {
        LayoutTemplate template = LayoutParser.createTemplate(stream);
        this.addLayout(template);
    }
}

