/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.rocketplatform.client.generated.ModpackLoadoutPricingTier;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class CheckoutCallback
extends ElementCallback {
    @SerializedName(value="on_complete")
    private ElementCallback onComplete;

    public CheckoutCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        if (!variableStorage.contains("selectedLoadoutId")) {
            RocketClientMod.getLogger().error("Unable to checkout: A loadout was not selected.");
            return;
        }
        if (!variableStorage.contains("selectedRegionId")) {
            RocketClientMod.getLogger().error("Unable to checkout: A region was not selected.");
            return;
        }
        if (!variableStorage.contains("selectedPriceTierName")) {
            RocketClientMod.getLogger().error("Unable to checkout: A price tier was not selected.");
            return;
        }
        String modpackId = RocketClientMod.getInstance().getModpackId();
        String versionId = Integer.toString(RocketClientMod.getInstance().getPackMetadata().getVersion().getId());
        String loadoutId = (String)variableStorage.retrieve("selectedLoadoutId");
        String regionId = (String)variableStorage.retrieve("selectedRegionId");
        ModpackLoadoutPricingTier pricingTier = ModpackLoadoutPricingTier.valueOf((String)((String)variableStorage.retrieve("selectedPriceTierName")));
        String gameServerId = (String)variableStorage.retrieve("gameServerId");
        ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.createPurchaseModpackAddress(modpackId, versionId, loadoutId, regionId, pricingTier, gameServerId))).whenComplete((address, e) -> {
            if (e != null) {
                RocketClientMod.getLogger().error("Unable to checkout: Failed to create purchase address.", e);
                return;
            }
            if (address == null) {
                RocketClientMod.getLogger().error("Unable to checkout: Failed to create purchase address.");
                return;
            }
            Util.getPlatform().openUri(URI.create(address.getUrl()));
            if (this.onComplete != null) {
                RenderSystem.recordRenderCall(() -> CallbackHolder.runCallbacks(screen, holder, this.onComplete, variableStorage));
            }
        });
    }
}

