/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.integration;

import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.registries.DeferredHolder;

public enum ModIntegration {
    CREATE_GARNISHED("garnished"),
    CREATE_DND("dndesires"),
    QUICKSAND("quicksand");

    private final String id;

    private ModIntegration(String id) {
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public boolean enabled() {
        return ModList.get().isLoaded(this.id);
    }

    public ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.id, (String)path);
    }

    public ModLoadedCondition condition() {
        return new ModLoadedCondition(this.id);
    }

    public void onConstructMod() {
    }

    public void onCommonSetup() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientSetup() {
    }

    public DeferredHolder<FanProcessingType, FanProcessingType> fanType(String path) {
        return DeferredHolder.create((ResourceKey)CreateRegistries.FAN_PROCESSING_TYPE, (ResourceLocation)this.asResource(path));
    }

    public DeferredHolder<RecipeType<?>, RecipeType<StandardProcessingRecipe<SingleRecipeInput>>> recipeType(String path) {
        return DeferredHolder.create((ResourceKey)Registries.RECIPE_TYPE, (ResourceLocation)this.asResource(path));
    }

    public static class Constants {
        public static final String CREATE_GARNISHED = "garnished";
        public static final String CREATE_DND = "dndesires";
        public static final String QUICKSAND = "quicksand";
    }
}

