/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.processing.forger;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.advancements.AdvancementBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.experience.BlazeExperienceBlock;
import plus.dragons.createenchantmentindustry.common.processing.forger.BlazeForgerBlockEntity;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlockEntities;

public class BlazeForgerBlock
extends BlazeExperienceBlock<BlazeForgerBlockEntity> {
    public BlazeForgerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        AdvancementBehaviour.setPlacedBy((Level)level, (BlockPos)pos, (LivingEntity)placer);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlazeForgerBlockEntity blockEntity = (BlazeForgerBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (blockEntity == null) {
            return InteractionResult.PASS;
        }
        ItemStack extracted = blockEntity.extractItem(false);
        if (!extracted.isEmpty()) {
            player.getInventory().placeItemBackInInventory(extracted);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemInteractionResult result = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        if (result.result() != InteractionResult.PASS) {
            return result;
        }
        BlazeForgerBlockEntity blockEntity = (BlazeForgerBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (blockEntity == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack remainder = blockEntity.insertItem(stack, false);
        if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)remainder) && remainder.getCount() == stack.getCount()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        player.setItemInHand(hand, remainder);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    protected MapCodec<BlazeForgerBlock> codec() {
        return BlazeForgerBlock.simpleCodec(BlazeForgerBlock::new);
    }

    public Class<BlazeForgerBlockEntity> getBlockEntityClass() {
        return BlazeForgerBlockEntity.class;
    }

    public BlockEntityType<? extends BlazeForgerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CEIBlockEntities.BLAZE_FORGER.get();
    }
}

