/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.BCStreamCodec;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.FlightData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.ItemData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class FlightEntity
extends ModuleEntity<FlightData> {
    private Optional<BooleanProperty> elytraEnabled = Optional.empty();
    private Optional<BooleanProperty> creativeEnabled = Optional.empty();
    private Optional<DecimalProperty> elytraBoost = Optional.empty();
    public static final Codec<FlightEntity> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DEModules.codec().fieldOf("module").forGetter(ModuleEntity::getModule), (App)Codec.INT.fieldOf("gridx").forGetter(ModuleEntity::getGridX), (App)Codec.INT.fieldOf("gridy").forGetter(ModuleEntity::getGridY), (App)BooleanProperty.CODEC.optionalFieldOf("elytra_enabled").forGetter(e -> e.elytraEnabled), (App)BooleanProperty.CODEC.optionalFieldOf("creative_enabled").forGetter(e -> e.creativeEnabled), (App)DecimalProperty.CODEC.optionalFieldOf("elytra_boost").forGetter(e -> e.elytraBoost)).apply((Applicative)builder, FlightEntity::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FlightEntity> STREAM_CODEC = BCStreamCodec.composite(DEModules.streamCodec(), ModuleEntity::getModule, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridX, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridY, (StreamCodec)ByteBufCodecs.optional(BooleanProperty.STREAM_CODEC), e -> e.elytraEnabled, (StreamCodec)ByteBufCodecs.optional(BooleanProperty.STREAM_CODEC), e -> e.creativeEnabled, (StreamCodec)ByteBufCodecs.optional(DecimalProperty.STREAM_CODEC), e -> e.elytraBoost, FlightEntity::new);

    public FlightEntity(Module<FlightData> module) {
        super(module);
        if (module.getData().elytra()) {
            this.elytraEnabled = Optional.of(new BooleanProperty("flight_mod.elytra", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED));
            this.elytraBoost = Optional.of(new DecimalProperty("flight_mod.elytra_boost", module.getData().elytraSpeed()).setFormatter(ConfigProperty.DecimalFormatter.PERCENT_0).range(0.0, module.getData().elytraSpeed()));
        }
        if (module.getData().creative()) {
            this.creativeEnabled = Optional.of(new BooleanProperty("flight_mod.creative", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED));
        }
    }

    FlightEntity(Module<?> module, int gridX, int gridY, Optional<BooleanProperty> elytraEnabled, Optional<BooleanProperty> creativeEnabled, Optional<DecimalProperty> elytraBoost) {
        super(module, gridX, gridY);
        this.elytraEnabled = elytraEnabled;
        this.creativeEnabled = creativeEnabled;
        this.elytraBoost = elytraBoost;
    }

    @Override
    public ModuleEntity<?> copy() {
        return new FlightEntity(this.module, this.getGridX(), this.getGridY(), this.elytraEnabled.map(BooleanProperty::copy), this.creativeEnabled.map(BooleanProperty::copy), this.elytraBoost.map(DecimalProperty::copy));
    }

    @Override
    public void getEntityProperties(List<ConfigProperty> properties) {
        super.getEntityProperties(properties);
        this.elytraEnabled.ifPresent(properties::add);
        this.creativeEnabled.ifPresent(properties::add);
        this.elytraBoost.ifPresent(properties::add);
    }

    @Override
    public void onInstalled(ModuleContext context) {
    }

    public boolean getElytraEnabled() {
        return this.elytraEnabled.isPresent() && this.elytraEnabled.get().getValue();
    }

    public boolean getCreativeEnabled() {
        return this.creativeEnabled.isPresent() && this.creativeEnabled.get().getValue();
    }

    public double getElytraBoost() {
        return this.elytraBoost.map(DecimalProperty::getValue).orElse(0.0);
    }

    @Override
    public void saveEntityToStack(ItemStack stack, ModuleContext context) {
        this.elytraEnabled.ifPresent(e -> stack.set(ItemData.BOOL_ITEM_PROP_1, (Object)e.copy()));
        this.creativeEnabled.ifPresent(e -> stack.set(ItemData.BOOL_ITEM_PROP_2, (Object)e.copy()));
        this.elytraBoost.ifPresent(e -> stack.set(ItemData.DECIMAL_ITEM_PROP_1, (Object)e.copy()));
    }

    @Override
    public void loadEntityFromStack(ItemStack stack, ModuleContext context) {
        this.elytraEnabled = FlightEntity.optionalDefault((BooleanProperty)stack.get(ItemData.BOOL_ITEM_PROP_1), this.elytraEnabled).map(BooleanProperty::copy);
        this.creativeEnabled = FlightEntity.optionalDefault((BooleanProperty)stack.get(ItemData.BOOL_ITEM_PROP_2), this.creativeEnabled).map(BooleanProperty::copy);
        this.elytraBoost = FlightEntity.optionalDefault((DecimalProperty)stack.get(ItemData.DECIMAL_ITEM_PROP_1), this.elytraBoost).map(DecimalProperty::copy);
    }
}

