/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePotentiometer;
import com.brandon3055.draconicevolution.init.DEContent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Potentiometer
extends EntityBlockBCore {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    protected static final VoxelShape AABB_DOWN = Shapes.box((double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);
    protected static final VoxelShape AABB_UP = Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375);
    protected static final VoxelShape AABB_NORTH = Shapes.box((double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.9375, (double)1.0);
    protected static final VoxelShape AABB_SOUTH = Shapes.box((double)0.0625, (double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.0625);
    protected static final VoxelShape AABB_WEST = Shapes.box((double)0.9375, (double)0.0625, (double)0.0625, (double)1.0, (double)0.9375, (double)0.9375);
    protected static final VoxelShape AABB_EAST = Shapes.box((double)0.0, (double)0.0625, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375);

    public Potentiometer(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
        this.canProvidePower = true;
        this.setBlockEntity(() -> DEContent.TILE_POTENTIOMETER.get(), false);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected static boolean canPlaceBlock(Level worldIn, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.relative(direction);
        return worldIn.getBlockState(blockpos).isFaceSturdy((BlockGetter)worldIn, blockpos, direction.getOpposite());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return Potentiometer.canPlaceBlock(context.getLevel(), context.getClickedPos(), context.getClickedFace().getOpposite()) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace()) : (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.DOWN);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return Potentiometer.canSupportCenter((LevelReader)worldIn, (BlockPos)pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()), (Direction)((Direction)state.getValue((Property)FACING)));
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.is(newState.getBlock())) {
            BlockEntity tile = worldIn.getBlockEntity(pos);
            if (tile instanceof TilePotentiometer && ((TilePotentiometer)tile).power.get() > 0) {
                this.updateNeighbors(state, worldIn, pos);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    private void updateNeighbors(BlockState state, Level world, BlockPos pos) {
        world.updateNeighborsAt(pos, (Block)this);
        world.updateNeighborsAt(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()), (Block)this);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction enumfacing = (Direction)state.getValue((Property)FACING);
        return switch (enumfacing) {
            case Direction.EAST -> AABB_EAST;
            case Direction.WEST -> AABB_WEST;
            case Direction.SOUTH -> AABB_SOUTH;
            case Direction.UP -> AABB_UP;
            case Direction.DOWN -> AABB_DOWN;
            default -> AABB_NORTH;
        };
    }
}

