/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.hud;

import codechicken.lib.gui.modular.elements.GuiContextMenu;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.sprite.Material;
import com.brandon3055.brandonscore.api.hud.AbstractHudElement;
import com.brandon3055.brandonscore.api.math.Vector2;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.api.modules.entities.UndyingEntity;
import com.brandon3055.draconicevolution.client.DEGuiTextures;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.equipment.IModularArmor;
import com.brandon3055.draconicevolution.items.tools.DraconiumCapacitor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ShieldHudElement
extends AbstractHudElement {
    private static int TOTEM_EFFECT_TIME = 32;
    private static Random rand = new Random();
    private Minecraft mc = Minecraft.getInstance();
    private double shieldCharge = 0.0;
    private Component shieldText = Component.empty();
    private double coolDown = 0.0;
    private double energyBar = 0.0;
    private Component energyText = Component.empty();
    private double[] totemStatus = new double[0];
    private int totemEffect = 0;
    private long totemEffectSeed = 0L;
    private int totemEffectIndex = 0;
    private float hudOpacity = 1.0f;
    private int lastTotemCount = 0;
    private int lastChargedTotemCount = 0;
    private boolean renderHud = false;
    private boolean numericEnergy = true;
    private boolean showUndying = true;
    private int energyMode = 2;
    private float scale = 1.0f;
    private Material[] _effectMats = null;

    public ShieldHudElement() {
        super(new Vector2(0.0136, 0.9787));
        this.width = 119.0;
    }

    public void addConfigElements(GuiContextMenu menu) {
        super.addConfigElements(menu);
        menu.addOption(() -> Component.translatable((String)("hud_armor.draconicevolution.numeric." + this.numericEnergy)), this.runDirty(() -> {
            this.numericEnergy = !this.numericEnergy;
        }), new Component[]{Component.translatable((String)"hud_armor.draconicevolution.numeric.info")});
        menu.addOption(() -> Component.translatable((String)("hud_armor.draconicevolution.undying." + this.showUndying)), this.runDirty(() -> {
            this.showUndying = !this.showUndying;
        }), new Component[]{Component.translatable((String)"hud_armor.draconicevolution.undying.info")});
        menu.addOption(() -> Component.translatable((String)("hud_armor.draconicevolution.energy." + this.energyMode)), this.runDirty(() -> {
            this.energyMode = this.energyMode == 2 ? 0 : this.energyMode + 1;
        }), new Component[]{Component.translatable((String)"hud_armor.draconicevolution.energy.info")});
    }

    public void popTotem() {
        this.totemEffect = TOTEM_EFFECT_TIME;
        if (this.mc.level != null) {
            this.totemEffectSeed = this.mc.level.random.nextLong();
        }
        this.totemEffectIndex = 0;
        for (double totem : this.totemStatus) {
            if (totem == -1.0) break;
            ++this.totemEffectIndex;
        }
    }

    private boolean extended() {
        return this.numericEnergy || this.totemStatus.length > 0;
    }

    public double height() {
        return 17.0f * this.scale + (this.extended() ? 10.0f * this.scale : 0.0f);
    }

    public double width() {
        return 115.0f * this.scale;
    }

    public void tick(boolean configuring) {
        if (this.mc.player == null || !this.enabled) {
            this.renderHud = false;
            if (configuring) {
                this.setupExample();
            }
            return;
        }
        if (this.totemEffect > 0) {
            --this.totemEffect;
        }
        ItemStack chestStack = IModularArmor.getArmor((LivingEntity)this.mc.player);
        try (ModuleHost host = DECapabilities.getHost(chestStack);){
            IOPStorage opStorage = (IOPStorage)chestStack.getCapability(CapabilityOP.ITEM);
            if (chestStack.isEmpty() || host == null || opStorage == null) {
                this.renderHud = false;
                if (configuring) {
                    this.setupExample();
                }
                return;
            }
            ShieldControlEntity shieldControl = host.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null);
            if (shieldControl == null) {
                this.shieldCharge = 0.0;
                this.shieldText = Component.translatable((String)"hud_armor.draconicevolution.no_shield");
            } else if (!shieldControl.isShieldEnabled()) {
                this.shieldCharge = 0.0;
                this.shieldText = Component.translatable((String)"hud_armor.draconicevolution.shield_disabled");
            } else {
                double capacity = (double)shieldControl.getShieldCapacity() + shieldControl.getMaxShieldBoost();
                if (capacity == 0.0 && shieldControl.getMaxShieldBoost() > 0.0) {
                    capacity = shieldControl.getMaxShieldBoost();
                }
                double points = shieldControl.getShieldPoints();
                this.shieldCharge = capacity > 0.0 ? points / capacity : 0.0;
                this.shieldText = Component.literal((String)((int)points + "/" + (int)capacity));
                double maxCooldown = shieldControl.getMaxShieldCoolDown();
                this.coolDown = maxCooldown > 0.0 ? (double)shieldControl.getShieldCoolDown() / maxCooldown : 0.0;
            }
            long energy = opStorage.getOPStored();
            long maxEnergy = opStorage.getMaxOPStored();
            if (this.energyMode > 0) {
                ArrayList<ItemStack> capacitors = new ArrayList<ItemStack>(EquipmentManager.findItems(e -> e.getItem() instanceof DraconiumCapacitor, (LivingEntity)this.mc.player));
                for (ItemStack stack : this.mc.player.getInventory().items) {
                    if (!(stack.getItem() instanceof DraconiumCapacitor)) continue;
                    capacitors.add(stack);
                }
                long capMax = 0L;
                long capEnergy = 0L;
                for (ItemStack stack : capacitors) {
                    IOPStorage storage = (IOPStorage)stack.getCapability(CapabilityOP.ITEM);
                    if (storage == null) continue;
                    capMax = Utils.safeAdd((long)storage.getMaxOPStored(), (long)capMax);
                    capEnergy = Utils.safeAdd((long)storage.getOPStored(), (long)capEnergy);
                }
                if (this.energyMode == 1) {
                    energy = capEnergy;
                    maxEnergy = capMax;
                } else {
                    energy = Utils.safeAdd((long)capEnergy, (long)energy);
                    maxEnergy = Utils.safeAdd((long)capMax, (long)maxEnergy);
                }
            }
            double d = this.energyBar = maxEnergy > 0L ? (double)energy / (double)maxEnergy : 0.0;
            if (this.numericEnergy) {
                this.energyText = Component.translatable((String)"op.brandonscore.op").append(": " + Utils.formatNumber((long)energy));
            }
            if (this.showUndying) {
                List totems = host.getEntitiesByType(ModuleTypes.UNDYING).map(e -> (UndyingEntity)e).sorted(Comparator.comparing(e -> e.getModule().getModuleTechLevel().index)).collect(Collectors.toList());
                int chargedTotems = 0;
                this.totemStatus = new double[totems.size()];
                for (int i = 0; i < totems.size(); ++i) {
                    UndyingEntity entity = (UndyingEntity)totems.get(i);
                    if (entity.isCharged()) {
                        ++chargedTotems;
                    }
                    this.totemStatus[i] = entity.isCharged() ? -1.0 : entity.getCharge();
                }
                if (this.lastTotemCount != totems.size()) {
                    this.lastTotemCount = totems.size();
                } else if (chargedTotems > this.lastChargedTotemCount && this.mc.level != null) {
                    this.mc.level.playLocalSound(this.mc.player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 2.0f, false);
                }
                this.lastChargedTotemCount = chargedTotems;
            } else {
                this.totemStatus = new double[0];
            }
        }
        this.renderHud = true;
    }

    private void setupExample() {
        double[] dArray;
        this.renderHud = this.enabled;
        this.shieldCharge = 0.5315875613747955;
        this.shieldText = Component.literal((String)"1624/3055");
        this.energyBar = 0.75;
        this.energyText = Component.translatable((String)"op.brandonscore.op").append(": 42M");
        if (this.showUndying) {
            double[] dArray2 = new double[3];
            dArray2[0] = -1.0;
            dArray2[1] = 0.5;
            dArray = dArray2;
            dArray2[2] = 0.75;
        } else {
            dArray = new double[]{};
        }
        this.totemStatus = dArray;
    }

    public void render(GuiRender render, float partialTicks, boolean configuring) {
        if (!this.renderHud) {
            return;
        }
        render.pose().pushPose();
        render.pose().translate(this.xPos(), this.yPos(), 0.0);
        render.pose().scale(this.scale, this.scale, this.scale);
        this.hudOpacity = 1.0f;
        double width = this.width() - (double)(16.0f * this.scale);
        double height = this.height() - (double)(this.extended() ? 10.0f * this.scale : 0.0f);
        double iconSize = height - 2.0;
        render.tex(DEGuiTextures.get("hud/shield_icon"), 0.0, height / 2.0 - iconSize / 2.0, iconSize, iconSize, 1.0f, 1.0f, 1.0f, this.hudOpacity);
        render.pose().translate(iconSize, 0.0, 0.0);
        boolean xl = false;
        int shH = xl ? 11 : 7;
        int reH = xl ? 3 : 2;
        int divH = xl ? 2 : 1;
        int backgroundColor = this.scaleAlpha(-16711653);
        int borderColor = this.scaleAlpha(-12251305);
        int borderColorEnd = (borderColor & 0xFEFEFE) >> 1 | borderColor & 0xFF000000;
        render.toolTipBackground(0.0, 0.0, width, height, backgroundColor, borderColor, borderColorEnd);
        float charge = (float)(this.shieldCharge >= 0.0 ? this.shieldCharge : 0.0);
        double bw = width - 4.0;
        Material mat = DEGuiTextures.get("hud/ryg_bar");
        render.partialSprite(mat.renderType(GuiRender::texColType), 2.0, 2.0, 2.0 + bw * (double)charge, (double)(2 + shH), mat.sprite(), 0.0f, 0.0f, charge, 1.0f, 1.0f, 1.0f, 1.0f, this.hudOpacity);
        render.rect(2.0 + bw * (double)charge, 2.0, bw * (1.0 - (double)charge), (double)shH, this.scaleAlpha(-16711653));
        render.rect(2.0, (double)(2 + shH), width - 4.0, (double)divH, this.scaleAlpha(-14547157));
        render.rect(2.0, (double)(2 + shH + divH), bw * this.coolDown, (double)reH, this.scaleAlpha(-8126464));
        render.rect(2.0 + bw * this.coolDown, (double)(2 + shH + divH), bw * (1.0 - this.coolDown), (double)reH, this.scaleAlpha(-16732140));
        render.rect(2.0, (double)(2 + shH + divH + reH), width - 4.0, (double)divH, this.scaleAlpha(-14547157));
        render.rect(2.0, (double)(2 + shH + divH + reH + divH), bw * this.energyBar, (double)reH, this.scaleAlpha(-16265512));
        render.rect(2.0 + bw * this.energyBar, (double)(2 + shH + divH + reH + divH), bw * (1.0 - this.energyBar), (double)reH, this.scaleAlpha(-16711653));
        if (this.totemStatus.length > 0) {
            double x = width - 8.0;
            for (double state : this.totemStatus) {
                render.texRect(DEGuiTextures.get("hud/undying"), x, height + 1.0, 8.0, 8.0, this.scaleAlpha(state != -1.0 ? -65536 : -1));
                if (state != -1.0) {
                    RenderUtils.drawPieProgress((GuiRender)render, (double)x, (double)(height + 1.0), (double)8.0, (double)state, (double)0.0, (int)-2130706433);
                }
                x -= 9.0;
            }
        }
        if (this.totemEffect > 0) {
            float progress = 1.0f - ((float)this.totemEffect - partialTicks) / (float)TOTEM_EFFECT_TIME;
            this.particleExplosion(render, width - 4.0 - (double)(this.totemEffectIndex * 9), height + 5.0, progress, rand);
        }
        render.flush();
        double tPos = width / 2.0 - (double)this.mc.font.width((FormattedText)this.shieldText) / 2.0;
        render.drawString(this.shieldText, (double)((float)tPos), xl ? 4.0 : 2.0, this.scaleAlpha(-16776961), false);
        if (this.numericEnergy && !this.energyText.getString().isEmpty()) {
            render.drawString(this.energyText, 2.0, (double)((float)height + 1.0f), this.scaleAlpha(-1), true);
        }
        render.pose().popPose();
    }

    public void particleExplosion(GuiRender render, double x, double y, float progress, Random rand) {
        rand.setSeed(this.totemEffectSeed);
        int pCount = 128;
        int size = 100;
        double scale = 6.0;
        for (int p = 0; p < pCount; ++p) {
            float life = 0.5f + rand.nextFloat() * 0.5f;
            float age = Mth.clamp((float)(progress / life), (float)0.0f, (float)1.0f);
            float fadeOut = Math.min(1.0f, (1.0f - age) * 10.0f);
            boolean altColour = rand.nextInt(4) == 0;
            float red = (altColour ? 0.6f : 0.1f) + rand.nextFloat() * 0.2f;
            float green = (altColour ? 0.6f : 0.4f) + rand.nextFloat() * 0.3f;
            float blue = rand.nextFloat() * 0.2f;
            double dir = rand.nextDouble() * Math.PI * 2.0;
            double dist = rand.nextGaussian() * (double)size;
            double pX = x + (double)Mth.sin((float)((float)dir)) * dist * (double)progress;
            double pY = y + (double)Mth.cos((float)((float)dir)) * dist * (double)progress;
            double ps = scale * (0.75 + rand.nextDouble() * 0.5) * (double)fadeOut;
            int index = Math.min((int)(age * 8.0f), 7);
            if (age >= 1.0f) continue;
            render.tex(this.getEffectMats()[index], pX - ps / 2.0, pY - ps / 2.0, ps, ps, red, green, blue, 1.0f);
        }
    }

    private int scaleAlpha(int colour) {
        int modifier = (int)(this.hudOpacity * 240.0f) + 15 << 24;
        return modifier | (colour &= 0xFFFFFF);
    }

    public void writeNBT(CompoundTag nbt) {
        super.writeNBT(nbt);
        nbt.putBoolean("show_numeric", this.numericEnergy);
        nbt.putBoolean("show_undying", this.showUndying);
        nbt.putFloat("scale", this.scale);
    }

    public void readNBT(CompoundTag nbt) {
        super.readNBT(nbt);
        this.numericEnergy = nbt.getBoolean("show_numeric");
        this.showUndying = nbt.getBoolean("show_undying");
        this.scale = nbt.getFloat("scale");
    }

    private Material[] getEffectMats() {
        if (this._effectMats == null) {
            this._effectMats = new Material[8];
            for (int i = 0; i < 8; ++i) {
                this._effectMats[i] = DEGuiTextures.get("effect/glitter_" + i);
            }
        }
        return this._effectMats;
    }
}

