/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.sound;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGenerator;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.lib.ISidedTileHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class GeneratorSoundHandler
implements ISidedTileHandler {
    private TileGenerator tile;
    private GeneratorSound activeSound = null;
    private boolean currentHigh = false;
    private boolean startHigh = false;

    public GeneratorSoundHandler(TileGenerator tile) {
        this.tile = tile;
    }

    @Override
    public void tick() {
        if (!this.tile.active.get()) {
            if (this.activeSound != null) {
                this.activeSound.fadeDown = true;
                if (this.activeSound.isStopped()) {
                    this.activeSound = null;
                }
            }
            return;
        }
        TileGenerator.Mode mode = (TileGenerator.Mode)this.tile.mode.get();
        if (this.activeSound == null || this.activeSound.isStopped()) {
            if (mode.index >= 2) {
                this.activeSound = new GeneratorSound(this, this.tile, (SoundEvent)DESounds.GENERATOR2.get(), this.startHigh ? 1.5f : 0.5f);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)this.activeSound);
                this.currentHigh = true;
            } else {
                this.activeSound = new GeneratorSound(this, this.tile, (SoundEvent)DESounds.GENERATOR1.get(), this.startHigh ? 1.0f : 0.5f);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)this.activeSound);
                this.currentHigh = false;
            }
        }
        if (mode.index >= 2) {
            if (!this.currentHigh) {
                this.activeSound.fadeUp = true;
                this.startHigh = false;
            } else {
                this.activeSound.targetPitch = mode == TileGenerator.Mode.NORMAL ? 0.6f : (mode == TileGenerator.Mode.PERFORMANCE ? 1.3f : 1.6f);
            }
        } else if (this.currentHigh) {
            this.activeSound.fadeDown = true;
            this.startHigh = true;
        } else {
            this.activeSound.targetPitch = mode == TileGenerator.Mode.ECO_PLUS ? 0.5f : 0.7f;
        }
    }

    public class GeneratorSound
    extends SimpleSoundInstance
    implements TickableSoundInstance {
        public boolean donePlaying = false;
        private TileGenerator tile;
        private float targetPitch;
        boolean fadeUp = false;
        boolean fadeDown = false;

        public GeneratorSound(GeneratorSoundHandler this$0, TileGenerator tile, SoundEvent sound, float startPitch) {
            super(sound, SoundSource.BLOCKS, 0.3f, 1.0f, tile.getLevel().random, tile.getBlockPos());
            this.tile = tile;
            this.looping = true;
            this.pitch = startPitch;
            this.targetPitch = startPitch;
        }

        public boolean isStopped() {
            return this.donePlaying;
        }

        public void tick() {
            this.x = (float)this.tile.getBlockPos().getX() + 0.5f;
            this.y = (float)this.tile.getBlockPos().getY() + 0.5f;
            this.z = (float)this.tile.getBlockPos().getZ() + 0.5f;
            if (this.fadeUp) {
                this.targetPitch = 1.5f;
            } else if (this.fadeDown) {
                this.targetPitch = 0.5f;
            }
            if (this.fadeUp && this.pitch >= 1.0f || this.fadeDown && (double)this.pitch <= 0.55 || this.tile.isRemoved()) {
                this.donePlaying = true;
                this.looping = false;
            }
            this.pitch = (float)MathHelper.approachExp((double)this.pitch, (double)this.targetPitch, (double)0.05);
        }
    }
}

