/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.client;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.client.ExplorersCompassClient;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.connect.NewWayPoint;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import com.chaosthedude.explorerscompass.util.RenderUtils;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.mojang.datafixers.util.Pair;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class ExplorersCompassOverlay
implements LayeredDraw.Layer {
    public static final Minecraft mc = Minecraft.getInstance();
    public static CompassState state = CompassState.INACTIVE;

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalPlayer player;
        ItemStack stack;
        if (ExplorersCompassOverlay.mc.player != null && ExplorersCompassOverlay.mc.level != null && !ExplorersCompassOverlay.mc.options.hideGui && !mc.getDebugOverlay().showDebugScreen() && (ExplorersCompassOverlay.mc.screen == null || ((Boolean)ConfigHandler.CLIENT.displayWithChatOpen.get()).booleanValue() && ExplorersCompassOverlay.mc.screen instanceof ChatScreen) && (stack = ItemUtils.getHeldItem((Player)(player = ExplorersCompassOverlay.mc.player), ExplorersCompass.explorersCompass)) != null && stack.getItem() instanceof ExplorersCompassItem) {
            ExplorersCompassItem compass = (ExplorersCompassItem)stack.getItem();
            if (compass.getState(stack) == CompassState.SEARCHING) {
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.searching", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), 5, 5, 0xAAAAAA, 4);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.radius", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, String.valueOf(compass.getSearchRadius(stack)), 5, 5, 0xAAAAAA, 7);
            } else if (compass.getState(stack) == CompassState.FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.found", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), 5, 5, 0xAAAAAA, 4);
                if (compass.shouldDisplayCoordinates(stack)) {
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.coordinates", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, compass.getFoundStructureX(stack) + ", " + compass.getFoundStructureZ(stack), 5, 5, 0xAAAAAA, 7);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.distance", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 9);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, String.valueOf(StructureUtils.getHorizontalDistanceToLocation((Player)player, compass.getFoundStructureX(stack), compass.getFoundStructureZ(stack))), 5, 5, 0xAAAAAA, 10);
                }
            } else if (compass.getState(stack) == CompassState.NOT_FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.notFound", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), 5, 5, 0xAAAAAA, 4);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.radius", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, String.valueOf(compass.getSearchRadius(stack)), 5, 5, 0xAAAAAA, 7);
            }
            if (((Boolean)ConfigHandler.CLIENT.showHaveFound.get()).booleanValue()) {
                if (ExplorersCompassClient.isFound == 2 && !ExplorersCompassClient.HaveFound.isEmpty() && ExplorersCompassClient.HaveFound.get(0) != null) {
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.have_searched", (Object[])new Object[0]), 64, 5, 0xFFFFFF, 0);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)((String)ExplorersCompassClient.HaveFound.get(ExplorersCompassClient.isFound - 2).getFirst()), (Object[])new Object[0]), 64, 5, 0xAAAAAA, 1);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, (String)ExplorersCompassClient.HaveFound.get(ExplorersCompassClient.isFound - 2).getSecond(), 64, 5, 0xAAAAAA, 2);
                } else if (ExplorersCompassClient.isFound >= 3 && !ExplorersCompassClient.HaveFound.isEmpty() && ExplorersCompassClient.HaveFound.get(ExplorersCompassClient.isFound - 2) != null && ExplorersCompassClient.HaveFound.get(ExplorersCompassClient.isFound - 3) != null) {
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.have_searched", (Object[])new Object[0]), 64, 5, 0xFFFFFF, 0);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)((String)ExplorersCompassClient.HaveFound.get(ExplorersCompassClient.isFound - 2).getFirst()), (Object[])new Object[0]), 64, 5, 0xAAAAAA, 1);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, (String)ExplorersCompassClient.HaveFound.get(ExplorersCompassClient.isFound - 2).getSecond(), 64, 5, 0xAAAAAA, 2);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)((String)ExplorersCompassClient.HaveFound.get(ExplorersCompassClient.isFound - 3).getFirst()), (Object[])new Object[0]), 64, 5, 0xAAAAAA, 4);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, (String)ExplorersCompassClient.HaveFound.get(ExplorersCompassClient.isFound - 3).getSecond(), 64, 5, 0xAAAAAA, 5);
                }
            }
            if (compass.getState(stack) == CompassState.FOUND && state != CompassState.FOUND) {
                if (ModList.get().isLoaded("xaerominimap") && ((Boolean)ConfigHandler.CLIENT.newWayPoint.get()).booleanValue()) {
                    NewWayPoint.addPoint(compass.getFoundStructureX(stack), compass.getFoundStructureZ(stack), (Player)player, StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), player.level());
                }
                ExplorersCompassClient.HaveFound.put(ExplorersCompassClient.isFound, (Pair<String, String>)new Pair((Object)StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), (Object)(compass.getFoundStructureX(stack) + ", " + compass.getFoundStructureZ(stack))));
                ++ExplorersCompassClient.isFound;
            }
            state = compass.getState(stack);
        }
    }
}

