/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core.filters;

import com.almostreliable.lootjs.core.filters.IdFilter;
import com.almostreliable.lootjs.core.filters.ItemFilterImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.common.ItemAbility;

public interface ItemFilter {
    public static final ItemFilter NONE = itemStack -> false;
    public static final ItemFilter ANY = itemStack -> true;
    public static final ItemFilter EMPTY = ItemStack::isEmpty;
    public static final ItemFilter ARMOR = itemStack -> itemStack.getItem() instanceof ArmorItem;
    public static final ItemFilter EDIBLE = itemStack -> itemStack.getFoodProperties(null) != null;
    public static final ItemFilter DAMAGEABLE = ItemStack::isDamageableItem;
    public static final ItemFilter DAMAGED = ItemStack::isDamaged;
    public static final ItemFilter ENCHANTED = ItemStack::isEnchanted;
    public static final ItemFilter BLOCK_ITEM = itemStack -> itemStack.getItem() instanceof BlockItem;

    public static ItemFilter hasEnchantment(IdFilter filter) {
        return ItemFilter.hasEnchantment(filter, MinMaxBounds.Ints.ANY);
    }

    public static ItemFilter hasEnchantment(IdFilter filter, MinMaxBounds.Ints levelBounds) {
        return new ItemFilterImpl.HasEnchantment(filter, levelBounds, (DataComponentType<ItemEnchantments>)DataComponents.ENCHANTMENTS);
    }

    public static ItemFilter hasStoredEnchantment(IdFilter filter) {
        return ItemFilter.hasStoredEnchantment(filter, MinMaxBounds.Ints.ANY);
    }

    public static ItemFilter hasStoredEnchantment(IdFilter filter, MinMaxBounds.Ints levelBounds) {
        return new ItemFilterImpl.HasEnchantment(filter, levelBounds, (DataComponentType<ItemEnchantments>)DataComponents.STORED_ENCHANTMENTS);
    }

    public static ItemFilter hasComponent(DataComponentType<?> ... types) {
        return new ItemFilterImpl.HasComponent(types);
    }

    public static ItemFilter tag(String tag) {
        if (tag.startsWith("#")) {
            tag = tag.substring(1);
        }
        return new ItemFilterImpl.ByTag((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tag)));
    }

    public static ItemFilter item(ItemStack otherItemStack, boolean checkComponents) {
        return new ItemFilterImpl.ByItem(otherItemStack, checkComponents);
    }

    public static ItemFilter equipmentSlot(EquipmentSlot slot) {
        return new ItemFilterImpl.IsEquipmentSlot(slot);
    }

    public static ItemFilter equipmentSlotGroup(EquipmentSlotGroup slotGroup) {
        return new ItemFilterImpl.IsEquipmentSlotGroup(slotGroup);
    }

    public static ItemFilter anyToolAction(String ... actions) {
        List<ItemAbility> toolActions = Arrays.stream(actions).map(ItemAbility::get).toList();
        Predicate<ItemStack> composite = ItemFilterImpl.AnyOfToolAction.compose(toolActions);
        return new ItemFilterImpl.AnyOfToolAction(toolActions, composite);
    }

    public static ItemFilter toolAction(String ... actions) {
        List<ItemAbility> toolActions = Arrays.stream(actions).map(ItemAbility::get).toList();
        Predicate<ItemStack> composite = ItemFilterImpl.AllOfToolAction.compose(toolActions);
        return new ItemFilterImpl.AllOfToolAction(toolActions, composite);
    }

    public static ItemFilter allOf(ItemFilter ... itemFilters) {
        Objects.requireNonNull(itemFilters);
        ItemFilter composite = ItemFilterImpl.AllOf.compose(itemFilters);
        return new ItemFilterImpl.AllOf(itemFilters, composite);
    }

    public static ItemFilter not(ItemFilter itemFilter) {
        return itemFilter.negate();
    }

    public static ItemFilter anyOf(ItemFilter ... itemFilters) {
        Objects.requireNonNull(itemFilters);
        ItemFilter composite = ItemFilterImpl.AnyOf.compose(itemFilters);
        return new ItemFilterImpl.AnyOf(itemFilters, composite);
    }

    public static ItemFilter custom(Predicate<ItemStack> predicate) {
        return new ItemFilterImpl.Custom(predicate, null);
    }

    public static ItemFilter custom(Predicate<ItemStack> predicate, String description) {
        return new ItemFilterImpl.Custom(predicate, description);
    }

    public boolean test(ItemStack var1);

    default public ItemFilter and(ItemFilter other) {
        Objects.requireNonNull(other);
        return itemStack -> this.test(itemStack) && other.test(itemStack);
    }

    default public ItemFilter negate() {
        return new ItemFilterImpl.Not(this);
    }

    default public ItemFilter or(ItemFilter other) {
        Objects.requireNonNull(other);
        return itemStack -> this.test(itemStack) || other.test(itemStack);
    }
}

