/*
 * Decompiled with CFR 0.152.
 */
package com.mcdart.xp_synthesiser;

import com.mcdart.xp_synthesiser.Config;
import com.mcdart.xp_synthesiser.blocks.SynthesiserMenu;
import com.mcdart.xp_synthesiser.blocks.SynthesiserScreen;
import com.mcdart.xp_synthesiser.blocks.XPSynthesiserBlock;
import com.mcdart.xp_synthesiser.blocks.XPSynthesiserBlockEntity;
import com.mcdart.xp_synthesiser.items.KillRecorderData;
import com.mcdart.xp_synthesiser.items.KillRecorderItem;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="xp_synthesiser")
public class XPSynthesiser {
    public static final String MODID = "xp_synthesiser";
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"xp_synthesiser");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"xp_synthesiser");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"xp_synthesiser");
    public static final DeferredHolder<Item, KillRecorderItem> KILL_RECORDER = ITEMS.register("kill_recorder", () -> new KillRecorderItem(false));
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"xp_synthesiser");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<KillRecorderData>> KILL_RECORDER_DATA_COMPONENT = DATA_COMPONENT_TYPE_REGISTER.register("kill_recorder_data", () -> DataComponentType.builder().persistent(KillRecorderData.CODEC).networkSynchronized(KillRecorderData.STREAM_CODEC).build());
    public static final DeferredHolder<Block, XPSynthesiserBlock> XP_SYNTHESISER_BLOCK = BLOCKS.register("xp_synthesiser", () -> new XPSynthesiserBlock(BlockBehaviour.Properties.of().noOcclusion().destroyTime(1.5f)));
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_REGISTER = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"xp_synthesiser");
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<XPSynthesiserBlockEntity>> XP_SYNTHESISER_BLOCK_ENTITY = BLOCK_ENTITY_REGISTER.register("xp_synthesiser_entity", () -> BlockEntityType.Builder.of(XPSynthesiserBlockEntity::new, (Block[])new Block[]{(Block)XP_SYNTHESISER_BLOCK.get()}).build(null));
    public static final DeferredItem<BlockItem> XP_SYNTHESISER_ITEM = ITEMS.registerSimpleBlockItem("xp_synthesiser", XP_SYNTHESISER_BLOCK);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> XP_SYNTHESISER_TAB = CREATIVE_MODE_TABS.register("xp_synthesiser", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.xp_synthesiser")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ((BlockItem)XP_SYNTHESISER_ITEM.get()).getDefaultInstance()).displayItems((parameters, output) -> {
        output.accept((ItemLike)KILL_RECORDER.get());
        output.accept((ItemLike)XP_SYNTHESISER_ITEM.get());
    }).build());
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"xp_synthesiser");
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"xp_synthesiser");
    public static final Supplier<MenuType<SynthesiserMenu>> SYNTHESISER_MENU = MENUS.register("xp_synthesiser", () -> IMenuTypeExtension.create(SynthesiserMenu::new));

    private static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, pos, state, be, side) -> {
            assert (be != null);
            return ((XPSynthesiserBlockEntity)be).energyStorage;
        }, new Block[]{(Block)XP_SYNTHESISER_BLOCK.get()});
    }

    public XPSynthesiser(IEventBus modEventBus, ModContainer modContainer) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        RECIPE_REGISTER.register(modEventBus);
        DATA_COMPONENT_TYPE_REGISTER.register(modEventBus);
        BLOCK_ENTITY_REGISTER.register(modEventBus);
        MENUS.register(modEventBus);
        modEventBus.addListener(XPSynthesiser::onRegisterCapabilities);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
        if (FMLEnvironment.dist.isClient()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    @SubscribeEvent
    public void killed(LivingDeathEvent event) {
        if (!event.getEntity().level().isClientSide() && event.getSource().getEntity() instanceof ServerPlayer) {
            int xpGained = event.getEntity().getExperienceReward((ServerLevel)event.getEntity().level(), event.getSource().getEntity());
            ((ServerPlayer)event.getSource().getEntity()).getInventory().items.forEach(slot -> {
                KillRecorderData oldData;
                if (slot.getItem() instanceof KillRecorderItem && (oldData = (KillRecorderData)slot.get((DataComponentType)KILL_RECORDER_DATA_COMPONENT.get())) != null && oldData.recording()) {
                    slot.update((DataComponentType)KILL_RECORDER_DATA_COMPONENT.get(), (Object)oldData, data -> data.addKill(xpGained));
                }
            });
        }
    }

    @EventBusSubscriber(modid="xp_synthesiser", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        private static void registerScreens(RegisterMenuScreensEvent event) {
            event.register(SYNTHESISER_MENU.get(), SynthesiserScreen::new);
        }
    }
}

