/*
 * Decompiled with CFR 0.152.
 */
package com.mcdart.xp_synthesiser.blocks;

import com.mcdart.xp_synthesiser.Config;
import com.mcdart.xp_synthesiser.XPSynthesiser;
import com.mcdart.xp_synthesiser.items.KillRecorderData;
import com.mcdart.xp_synthesiser.items.KillRecorderItem;
import com.mcdart.xp_synthesiser.util.HelperFunctions;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class XPSynthesiserBlockEntity
extends BlockEntity {
    public final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            XPSynthesiserBlockEntity.this.setChanged();
            if (XPSynthesiserBlockEntity.this.level != null && !XPSynthesiserBlockEntity.this.level.isClientSide()) {
                XPSynthesiserBlockEntity.this.level.sendBlockUpdated(XPSynthesiserBlockEntity.this.getBlockPos(), XPSynthesiserBlockEntity.this.getBlockState(), XPSynthesiserBlockEntity.this.getBlockState(), 3);
            }
        }

        @NotNull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.getItem() instanceof KillRecorderItem) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    public ItemStack currentItem = ItemStack.EMPTY;
    public int progress = 0;
    public final TrackedProgress trackedProgress = new TrackedProgress();
    public final TrackedEnergy trackedEnergy = new TrackedEnergy();
    public final EnergyStorage energyStorage = new EnergyStorage(1000000);

    public XPSynthesiserBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)XPSynthesiser.XP_SYNTHESISER_BLOCK_ENTITY.get(), pos, blockState);
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.progress = tag.getInt("progress");
        this.trackedProgress.set(0, tag.getInt("progress"));
        this.trackedProgress.set(1, tag.getInt("savedXP"));
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        if (this.itemHandler.getStackInSlot(0).getItem() instanceof KillRecorderItem) {
            this.currentItem = this.itemHandler.getStackInSlot(0);
        }
        if (tag.contains("energy") && tag.get("energy") != null) {
            this.energyStorage.deserializeNBT(registries, Objects.requireNonNull(tag.get("energy")));
        }
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("progress", this.trackedProgress.get(0));
        tag.putInt("savedXP", this.trackedProgress.get(1));
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.put("energy", this.energyStorage.serializeNBT(registries));
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (!level.isClientSide() && t instanceof XPSynthesiserBlockEntity) {
            ((XPSynthesiserBlockEntity)t).tickSynthesiser();
        }
    }

    public void tickSynthesiser() {
        if (this.itemHandler != null && !this.itemHandler.getStackInSlot(0).equals(ItemStack.EMPTY) && this.itemHandler.getStackInSlot(0).getItem() instanceof KillRecorderItem) {
            if (!this.currentItem.equals(this.itemHandler.getStackInSlot(0))) {
                this.setupNewItem(this.itemHandler.getStackInSlot(0));
            } else {
                this.progressCurrentItem();
            }
        } else {
            this.resetProgress();
        }
    }

    public void setupNewItem(ItemStack newItem) {
        this.currentItem = newItem;
        this.resetProgress();
    }

    public void progressCurrentItem() {
        KillRecorderData killRecorderData = (KillRecorderData)this.itemHandler.getStackInSlot(0).getOrDefault((DataComponentType)XPSynthesiser.KILL_RECORDER_DATA_COMPONENT.get(), (Object)KillRecorderData.createEmpty());
        if (killRecorderData.recordingEnd() > 0L) {
            int cost;
            int duration = (int)(killRecorderData.recordingEnd() - killRecorderData.recordingStart());
            int n = cost = Config.GENERAL.requiresPower.isTrue() ? (int)HelperFunctions.getTickCost(killRecorderData.xp(), duration) : 0;
            if (cost <= this.trackedEnergy.get(1)) {
                this.trackedEnergy.set(1, this.trackedEnergy.get(1) - cost);
                ++this.progress;
                this.trackedProgress.set(0, this.progress);
                if (this.progress >= duration) {
                    this.generateXP(killRecorderData);
                    this.resetProgress();
                }
            }
        }
    }

    public void resetProgress() {
        this.progress = 0;
        this.trackedProgress.set(0, this.progress);
    }

    public void generateXP(KillRecorderData data) {
        this.trackedProgress.set(1, this.trackedProgress.get(1) + data.xp());
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public static class TrackedProgress
    implements ContainerData {
        int progress = 0;
        int savedXP = 0;

        public int get(int idx) {
            if (idx == 0) {
                return this.progress;
            }
            if (idx == 1) {
                return this.savedXP;
            }
            return -1;
        }

        public void set(int idx, int val) {
            if (idx == 0) {
                this.progress = val;
            } else if (idx == 1) {
                this.savedXP = val;
            }
        }

        public int getCount() {
            return 2;
        }
    }

    public class TrackedEnergy
    implements ContainerData {
        public int get(int idx) {
            return XPSynthesiserBlockEntity.this.energyStorage.getEnergyStored();
        }

        public void set(int idx, int val) {
            if (val > XPSynthesiserBlockEntity.this.energyStorage.getEnergyStored()) {
                XPSynthesiserBlockEntity.this.energyStorage.receiveEnergy(val - XPSynthesiserBlockEntity.this.energyStorage.getEnergyStored(), false);
            } else {
                XPSynthesiserBlockEntity.this.energyStorage.extractEnergy(XPSynthesiserBlockEntity.this.energyStorage.getEnergyStored() - val, false);
            }
        }

        public int getCount() {
            return 1;
        }
    }
}

