/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.core;

import com.almostreliable.unified.unification.worldgen.WorldStripper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public final class AlmostUnifiedCommands {
    private static final String RADIUS = "radius";

    private AlmostUnifiedCommands() {
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        RequiredArgumentBuilder radiusArgument = (RequiredArgumentBuilder)Commands.argument((String)RADIUS, (ArgumentType)IntegerArgumentType.integer((int)0, (int)128)).executes(AlmostUnifiedCommands::onStripCommand);
        LiteralArgumentBuilder stripSubCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"strip").requires(source -> source.hasPermission(2))).then((ArgumentBuilder)radiusArgument)).executes(AlmostUnifiedCommands::onStripCommand);
        LiteralArgumentBuilder mainCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"almostunified").then((ArgumentBuilder)stripSubCommand)).executes(AlmostUnifiedCommands::onHelpCommand);
        dispatcher.register(mainCommand);
    }

    private static int onHelpCommand(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)""), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Almost Unified Commands").withStyle(ChatFormatting.GOLD), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"--------------------"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"strip <radius> - strips everything in the specified radius except for Bedrock and ores"), false);
        return 1;
    }

    private static int onStripCommand(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        if (player == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"This command can only be used in-game!"));
            return 0;
        }
        try {
            Integer radius = (Integer)context.getArgument(RADIUS, Integer.class);
            WorldStripper.stripWorld(player, level, radius);
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Please provide a valid radius!").withStyle(ChatFormatting.DARK_RED));
            return 0;
        }
        return 1;
    }
}

