/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.BlacksmithFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.BlacksmithFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionf;

public class BlacksmithFamiliarRenderer
extends MobRenderer<BlacksmithFamiliarEntity, BlacksmithFamiliarModel> {
    private static final ResourceLocation TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/blacksmith_familiar.png");

    public BlacksmithFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new BlacksmithFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_BLACKSMITH)), 0.3f);
        this.addLayer(new IngotsLayer(this, (RenderLayerParent<BlacksmithFamiliarEntity, BlacksmithFamiliarModel>)this));
    }

    public ResourceLocation getTextureLocation(BlacksmithFamiliarEntity entity) {
        return TEXTURES;
    }

    protected void setupRotations(BlacksmithFamiliarEntity pEntity, PoseStack pPoseStack, float pBob, float pYBodyRot, float pPartialTick, float pScale) {
        if (!pEntity.isSitting()) {
            super.setupRotations((LivingEntity)pEntity, pPoseStack, pBob, pYBodyRot, pPartialTick, pScale);
        }
    }

    private class IngotsLayer
    extends RenderLayer<BlacksmithFamiliarEntity, BlacksmithFamiliarModel> {
        public IngotsLayer(BlacksmithFamiliarRenderer blacksmithFamiliarRenderer, RenderLayerParent<BlacksmithFamiliarEntity, BlacksmithFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, BlacksmithFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            pMatrixStack.pushPose();
            float scale = 0.5f;
            pMatrixStack.scale(scale, scale, scale);
            for (int i = 0; i < pLivingEntity.getBars(); ++i) {
                pMatrixStack.pushPose();
                pMatrixStack.translate(i % 2 == 0 ? -0.3 : 0.3, 2.03 - (double)(i / 2) * 0.03, -0.15);
                pMatrixStack.mulPose(new Quaternionf().rotateXYZ(-1.5707964f, 0.0f, (float)i * ((float)Math.PI / 180)));
                Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer().renderItem((LivingEntity)pLivingEntity, new ItemStack((ItemLike)Items.IRON_INGOT), ItemDisplayContext.GROUND, false, pMatrixStack, pBuffer, pPackedLight);
                pMatrixStack.popPose();
            }
            pMatrixStack.popPose();
        }
    }
}

