/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.klikli_dev.occultism.registry.OccultismSounds;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;

public class ChalkItem
extends Item {
    ChalkGlyphBlock glyphBlock;
    boolean isBrush;

    public ChalkItem(Item.Properties properties, ChalkGlyphBlock glyphBlock) {
        super(properties);
        this.glyphBlock = glyphBlock;
        this.isBrush = false;
    }

    public ChalkItem(Item.Properties properties, ChalkGlyphBlock glyphBlock, boolean brush) {
        super(properties);
        this.glyphBlock = glyphBlock;
        this.isBrush = brush;
    }

    public ChalkGlyphBlock getGlyphBlock() {
        return this.glyphBlock;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        boolean isReplacing = level.getBlockState(pos).canBeReplaced(new BlockPlaceContext(context));
        if (!level.isClientSide) {
            if (this.isBrush && player != null && player.isCrouching() && level.getBlockState(pos).getBlock() instanceof ChalkGlyphBlock) {
                level.removeBlock(pos, false);
                level.playSound(null, pos, OccultismSounds.BRUSH.get(), SoundSource.PLAYERS, 0.5f, 1.0f + 0.5f * Objects.requireNonNull(context.getPlayer()).getRandom().nextFloat());
                return InteractionResult.SUCCESS;
            }
            if (context.getClickedFace() == Direction.UP && this.glyphBlock.canSurvive(level.getBlockState(pos.above()), (LevelReader)level, pos.above()) || isReplacing) {
                ItemStack heldChalk = context.getItemInHand();
                BlockPos placeAt = isReplacing ? pos : pos.above();
                boolean isSameChalkType = level.getBlockState(placeAt).getBlock() == this.glyphBlock;
                level.setBlockAndUpdate(placeAt, Objects.requireNonNull(this.glyphBlock.getStateForPlacement(new BlockPlaceContext(context))));
                if (player != null) {
                    level.playSound(null, pos, OccultismSounds.CHALK.get(), SoundSource.PLAYERS, 0.5f, 1.0f + 0.5f * player.getRandom().nextFloat());
                    if (!(player.isCreative() || isSameChalkType || Occultism.SERVER_CONFIG.itemSettings.unbreakableChalks.getAsBoolean())) {
                        heldChalk.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(heldChalk));
                    }
                }
            }
        }
        return InteractionResult.SUCCESS;
    }
}

