/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.blocks;

import com.mojang.serialization.MapCodec;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import rearth.belts.BlockEntitiesContent;
import rearth.belts.blocks.ChuteBlockEntity;
import rearth.belts.util.MathHelpers;

public class ChuteBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    private VoxelShape createShapeForDirection(Direction direction) {
        return Shapes.or((VoxelShape)MathHelpers.rotateVoxelShape(Shapes.box((double)0.125, (double)0.25, (double)0.875, (double)0.875, (double)1.0, (double)1.0), direction, AttachFace.FLOOR), (VoxelShape)MathHelpers.rotateVoxelShape(Shapes.box((double)0.1875, (double)0.3125, (double)1.0, (double)0.8125, (double)0.9375, (double)1.125), direction, AttachFace.FLOOR)).optimize();
    }

    public ChuteBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Optional candidate = world.getBlockEntity(pos, (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (candidate.isPresent()) {
            ChuteBlockEntity entity = (ChuteBlockEntity)((Object)candidate.get());
            if (!entity.isUsed()) {
                return super.useItemOn(stack, state, world, pos, player, hand, hit);
            }
            if (!world.isClientSide) {
                entity.assignFilterItem(stack, player);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        Optional candidate = world.getBlockEntity(pos, (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (candidate.isPresent()) {
            ChuteBlockEntity entity = (ChuteBlockEntity)((Object)candidate.get());
            if (!entity.isUsed()) {
                return super.useWithoutItem(state, world, pos, player, hit);
            }
            if (!world.isClientSide) {
                entity.resetFilterItem(player);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return SHAPES.computeIfAbsent(dir, this::createShapeForDirection);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction targetFacing = ctx.getClickedFace();
        if (targetFacing.getAxis().isVertical()) {
            targetFacing = ctx.getHorizontalDirection().getOpposite();
        }
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(ctx)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)targetFacing);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ChuteBlockEntity(pos, state);
    }

    protected boolean triggerEvent(BlockState state, Level world, BlockPos pos, int type, int data) {
        super.triggerEvent(state, world, pos, type, data);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(type, data);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof ChuteBlockEntity) {
                ChuteBlockEntity chuteBlockEntity = (ChuteBlockEntity)blockEntity;
                chuteBlockEntity.tick(world1, pos, state1, chuteBlockEntity);
            }
        };
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (world.isClientSide) {
            return super.playerWillDestroy(world, pos, state, player);
        }
        Optional chuteEntity = world.getBlockEntity(pos, (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (chuteEntity.isEmpty()) {
            return super.playerWillDestroy(world, pos, state, player);
        }
        ((ChuteBlockEntity)((Object)chuteEntity.get())).dropContent(world, pos);
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        boolean showExtra = Screen.hasControlDown();
        if (showExtra) {
            tooltip.add((Component)Component.translatable((String)"block.belts.chute.tooltip.1").withStyle(ChatFormatting.GRAY));
            if (Platform.isModLoaded((String)"ftbfiltersystem")) {
                tooltip.add((Component)Component.translatable((String)"block.belts.chute.tooltip.ftbfilters").withStyle(ChatFormatting.GRAY));
            }
        }
        super.appendHoverText(stack, context, tooltip, options);
    }
}

