/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.blocks;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.belts.BlockContent;
import rearth.belts.BlockEntitiesContent;
import rearth.belts.ItemContent;
import rearth.belts.api.item.ItemApi;
import rearth.belts.client.renderers.ChuteBeltRenderer;
import rearth.belts.util.SplineUtil;

public class ChuteBlockEntity
extends BlockEntity
implements BlockEntityTicker<ChuteBlockEntity> {
    private BlockPos target;
    private List<BlockPos> midPoints = new ArrayList<BlockPos>();
    private final Deque<BeltItem> movingItems = new ArrayDeque<BeltItem>();
    private int outputQueue = 0;
    private BeltData beltData;
    private long lastTargetedTime;
    private BlockPos sourceBeltPos = BlockPos.ZERO;
    public ItemStack filteredItem = ItemStack.EMPTY;
    public ChuteBeltRenderer.Quad[] renderedModel;
    public Map<Short, Vec3> lastRenderedPositions = new HashMap<Short, Vec3>();
    private boolean networkDirty = false;

    public ChuteBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get(), pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, ChuteBlockEntity blockEntity) {
        ServerLevel serverWorld;
        if (world == null) {
            return;
        }
        if (this.target == null || this.target.equals((Object)BlockPos.ZERO)) {
            if (!world.isClientSide && !this.movingItems.isEmpty()) {
                this.dropContent(world, pos);
            }
            return;
        }
        if (this.beltData == null) {
            this.beltData = BeltData.create(this);
            if (world instanceof ServerLevel) {
                serverWorld = (ServerLevel)world;
                serverWorld.getChunkSource().blockChanged(pos);
            }
        }
        if (this.beltData == null) {
            this.target = null;
            this.midPoints = new ArrayList<BlockPos>();
            return;
        }
        if (world.isClientSide) {
            return;
        }
        this.moveItemsOnBelt();
        this.loadItemsOnBelt();
        if (world.getGameTime() % 19L == 0L) {
            this.assignTargetState(world);
        }
        if (this.networkDirty && world instanceof ServerLevel) {
            serverWorld = (ServerLevel)world;
            serverWorld.getChunkSource().blockChanged(pos);
            this.networkDirty = false;
        }
    }

    public void dropContent(Level world, BlockPos pos) {
        if (world.getGameTime() - this.lastTargetedTime < 20L && !this.sourceBeltPos.equals((Object)BlockPos.ZERO) && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            Optional sourceEntityCandidate = world.getBlockEntity(this.sourceBeltPos, (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get());
            if (sourceEntityCandidate.isPresent() && sourceEntityCandidate.get() != this) {
                ChuteBlockEntity source = (ChuteBlockEntity)((Object)sourceEntityCandidate.get());
                source.dropContent(world, pos);
                source.target = null;
                serverWorld.getChunkSource().blockChanged(this.sourceBeltPos);
                source.networkDirty = true;
                source.setChanged();
            }
        }
        for (BeltItem beltItem : this.movingItems) {
            ItemStack stack = beltItem.stack;
            Vec3 spawnAt = pos.getCenter();
            world.addFreshEntity((Entity)new ItemEntity(world, spawnAt.x, spawnAt.y, spawnAt.z, stack));
        }
        if (!this.movingItems.isEmpty() || this.target != null && !this.target.equals((Object)BlockPos.ZERO)) {
            ItemStack stack = new ItemStack((ItemLike)ItemContent.BELT.get(), 1);
            Vec3 spawnAt = pos.getCenter();
            world.addFreshEntity((Entity)new ItemEntity(world, spawnAt.x, spawnAt.y, spawnAt.z, stack));
        }
        this.movingItems.clear();
    }

    private void assignTargetState(Level world) {
        Optional beltTargetCandidate = world.getBlockEntity(this.target, (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (beltTargetCandidate.isPresent()) {
            ((ChuteBlockEntity)((Object)beltTargetCandidate.get())).lastTargetedTime = world.getGameTime();
            ((ChuteBlockEntity)((Object)beltTargetCandidate.get())).sourceBeltPos = this.worldPosition;
        } else {
            this.target = null;
            this.midPoints = new ArrayList<BlockPos>();
        }
    }

    private void moveItemsOnBelt() {
        double beltLength = this.beltData.totalLength();
        float beltSpeed = 1.0f;
        double progressDelta = (double)beltSpeed / beltLength / 20.0;
        boolean unloaded = false;
        this.outputQueue = 0;
        for (BeltItem pair : this.movingItems.reversed()) {
            ItemStack insertionStack;
            int insertedAmount;
            ChuteBlockEntity conveyorEndEntity;
            ItemApi.InventoryStorage targetInv;
            Optional conveyorEndEntityCandidate;
            boolean inQueue;
            float itemProgress = pair.progress;
            double newProgress = (double)itemProgress + progressDelta;
            boolean bl = inQueue = newProgress >= (double)this.getPotentialQueueStart();
            if (inQueue) {
                ++this.outputQueue;
            } else {
                pair.progress = (float)newProgress;
                this.networkDirty = true;
            }
            if (!inQueue || this.outputQueue != 1 || (conveyorEndEntityCandidate = this.level.getBlockEntity(this.target, (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get())).isEmpty() || (targetInv = ItemApi.BLOCK.find(this.level, this.target.offset((conveyorEndEntity = (ChuteBlockEntity)((Object)conveyorEndEntityCandidate.get())).getOwnFacing().getOpposite().getNormal()), null, null, conveyorEndEntity.getOwnFacing())) == null || (insertedAmount = targetInv.insert(insertionStack = pair.stack, true)) != insertionStack.getCount()) continue;
            targetInv.insert(insertionStack, false);
            this.outputQueue = 0;
            unloaded = true;
            this.networkDirty = true;
        }
        if (unloaded) {
            this.movingItems.removeLast();
        }
    }

    private void loadItemsOnBelt() {
        int extractionInterval = 26;
        long extractionOffset = this.worldPosition.asLong();
        if ((this.level.getGameTime() + extractionOffset) % (long)extractionInterval != 0L) {
            return;
        }
        if (this.getPotentialQueueStart() < 0.0f) {
            return;
        }
        ItemApi.InventoryStorage source = ItemApi.BLOCK.find(this.level, this.worldPosition.offset(this.getOwnFacing().getOpposite().getNormal()), null, null, this.getOwnFacing());
        if (source != null) {
            ItemStack extracted = null;
            for (int i = 0; i < source.getSlotCount(); ++i) {
                ItemStack extractingStack = source.getStackInSlot(i).copy();
                if (extractingStack.isEmpty() || !this.stackMatchesFilter(extractingStack)) continue;
                extractingStack.setCount(Math.min(extractingStack.getCount(), 64));
                int extractedAmount = source.extract(extractingStack, false);
                if (extractedAmount <= 0) continue;
                extracted = extractingStack.copyWithCount(extractedAmount);
                break;
            }
            if (extracted != null) {
                short id = (short)this.level.random.nextIntBetweenInclusive(Short.MIN_VALUE, Short.MAX_VALUE);
                this.movingItems.addFirst(new BeltItem(id, extracted));
                this.setChanged();
                this.networkDirty = true;
            }
        }
    }

    private boolean stackMatchesFilter(ItemStack stack) {
        FTBFilterSystemAPI.API filterAPI;
        if (this.filteredItem.isEmpty()) {
            return true;
        }
        if (Platform.isModLoaded((String)"ftbfiltersystem") && (filterAPI = FTBFilterSystemAPI.api()).isFilterItem(this.filteredItem)) {
            return filterAPI.doesFilterMatch(this.filteredItem, stack);
        }
        return stack.getItem().equals(this.filteredItem.getItem());
    }

    private float getPotentialQueueStart() {
        float squashFactor = 0.8f;
        double beltLength = this.beltData.totalLength();
        int queueCount = this.outputQueue;
        double queueSize = (double)((float)queueCount * squashFactor) / beltLength;
        return (float)(1.0 - queueSize);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        if (this.target != null) {
            nbt.putLong("target", this.target.asLong());
        }
        if (!this.midPoints.isEmpty()) {
            List<Long> midpointsArray = this.midPoints.stream().map(BlockPos::asLong).toList();
            nbt.putLongArray("midpoints", midpointsArray);
        }
        nbt.put("filter", this.filteredItem.saveOptional(registryLookup));
        ListTag positionsList = new ListTag();
        positionsList.addAll(this.movingItems.stream().map(pair -> {
            CompoundTag compound = new CompoundTag();
            compound.putFloat("a", pair.progress);
            compound.put("b", pair.stack.save(registryLookup));
            compound.putShort("id", pair.id);
            return compound;
        }).toList());
        nbt.put("moving", (Tag)positionsList);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.target = BlockPos.of((long)nbt.getLong("target"));
        long[] midPointsList = nbt.getLongArray("midpoints");
        this.midPoints = Arrays.stream(midPointsList).mapToObj(BlockPos::of).toList();
        this.filteredItem = ItemStack.parseOptional((HolderLookup.Provider)registryLookup, (CompoundTag)nbt.getCompound("filter"));
        ListTag positions = nbt.getList("moving", 10);
        this.movingItems.clear();
        this.movingItems.addAll(positions.stream().map(element -> {
            CompoundTag compound = (CompoundTag)element;
            float progress = compound.getFloat("a");
            short id = compound.getShort("id");
            Optional stackCandidate = ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)compound.get("b"));
            ItemStack stack = stackCandidate.isEmpty() ? ItemStack.EMPTY : (ItemStack)stackCandidate.get();
            return new BeltItem(progress, id, stack);
        }).toList());
        if (this.level == null) {
            return;
        }
        this.beltData = BeltData.create(this);
        if (this.level.isClientSide) {
            this.renderedModel = null;
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag base = super.getUpdateTag(registryLookup);
        this.saveAdditional(base, registryLookup);
        return base;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public Iterable<BeltItem> getMovingItems() {
        return this.movingItems;
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public BeltData getBeltData() {
        return this.beltData;
    }

    public Direction getOwnFacing() {
        return (Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
    }

    public boolean isUsed() {
        boolean usedAsTarget = this.level.getGameTime() - this.lastTargetedTime < 40L;
        boolean usedAsSource = this.target != null && !this.target.equals((Object)BlockPos.ZERO);
        return usedAsTarget || usedAsSource;
    }

    public void assignFromBeltItem(BlockPos target, List<BlockPos> midpoints) {
        this.target = target;
        this.midPoints = midpoints;
        this.beltData = BeltData.create(this);
        this.networkDirty = true;
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.getChunkSource().blockChanged(this.worldPosition);
        }
    }

    public List<Tuple<BlockPos, Direction>> getMidPointsWithTangents() {
        return this.midPoints.stream().filter(point -> this.level.getBlockState(point).getBlock().equals(BlockContent.CONVEYOR_SUPPORT_BLOCK.get())).map(point -> new Tuple(point, (Object)((Direction)this.level.getBlockState(point).getValue((Property)HorizontalDirectionalBlock.FACING)))).toList();
    }

    public void assignFilterItem(ItemStack stack, Player player) {
        if (stack.isEmpty()) {
            this.resetFilterItem(player);
            return;
        }
        player.sendSystemMessage((Component)Component.translatable((String)"message.belts.filter_set"));
        this.filteredItem = stack.copy();
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.getChunkSource().blockChanged(this.worldPosition);
        }
    }

    public void resetFilterItem(Player player) {
        player.sendSystemMessage((Component)Component.translatable((String)"message.belts.filter_reset"));
        this.filteredItem = ItemStack.EMPTY;
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.getChunkSource().blockChanged(this.worldPosition);
        }
    }

    public record BeltData(List<Tuple<Vec3, Vec3>> allPoints, double totalLength, Double[] segmentLengths) {
        @Nullable
        public static BeltData create(ChuteBlockEntity entity) {
            if (entity.getLevel() == null || entity.target == null || entity.target.equals((Object)BlockPos.ZERO)) {
                return null;
            }
            Optional targetCandidate = entity.getLevel().getBlockEntity(entity.getTarget(), (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get());
            if (targetCandidate.isEmpty()) {
                return null;
            }
            BlockPos conveyorStartPoint = entity.getBlockPos();
            BlockPos conveyorEndPoint = entity.getTarget();
            Vec3 conveyorStartDir = Vec3.atLowerCornerOf((Vec3i)entity.getOwnFacing().getNormal());
            Direction conveyorFacing = ((ChuteBlockEntity)((Object)targetCandidate.get())).getOwnFacing();
            Vec3 conveyorEndDir = Vec3.atLowerCornerOf((Vec3i)conveyorFacing.getOpposite().getNormal());
            List<Tuple<BlockPos, Direction>> conveyorMidPointsVisual = entity.getMidPointsWithTangents();
            Vec3 conveyorStartPointVisual = conveyorStartPoint.getCenter().add(conveyorStartDir.scale(-0.5));
            Vec3 conveyorEndPointVisual = conveyorEndPoint.getCenter().add(conveyorEndDir.scale(0.5));
            List<Tuple<Vec3, Vec3>> transformedMidPoints = conveyorMidPointsVisual.stream().map(elem -> new Tuple((Object)((BlockPos)elem.getA()).getCenter(), (Object)Vec3.atLowerCornerOf((Vec3i)((Direction)elem.getB()).getNormal()))).toList();
            List<Tuple<Vec3, Vec3>> segmentPoints = SplineUtil.getPointPairs(conveyorStartPointVisual, conveyorStartDir, conveyorEndPointVisual, conveyorEndDir, transformedMidPoints);
            Double[] segmentLengths = new Double[segmentPoints.size() - 1];
            double totalLength = 0.0;
            for (int i = 0; i < segmentPoints.size() - 1; ++i) {
                Tuple<Vec3, Vec3> from = segmentPoints.get(i);
                Tuple<Vec3, Vec3> to = segmentPoints.get(i + 1);
                double length = SplineUtil.getLineLength((Vec3)from.getA(), (Vec3)from.getB(), (Vec3)to.getA(), ((Vec3)to.getB()).scale(1.0));
                segmentLengths[i] = length;
                totalLength += length;
            }
            return new BeltData(segmentPoints, totalLength, segmentLengths);
        }
    }

    public static class BeltItem {
        public float progress;
        public final short id;
        public final ItemStack stack;

        public BeltItem(short id, ItemStack stack) {
            this.id = id;
            this.stack = stack;
        }

        public BeltItem(float progress, short id, ItemStack stack) {
            this.id = id;
            this.stack = stack;
            this.progress = progress;
        }
    }
}

