/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rearth.belts.BlockContent;
import rearth.belts.BlockEntitiesContent;
import rearth.belts.ComponentContent;
import rearth.belts.blocks.ChuteBlockEntity;
import rearth.belts.items.BeltItem;
import rearth.belts.util.MathHelpers;
import rearth.belts.util.SplineUtil;

public class BeltOutlineRenderer {
    public static void renderPlannedBelt(ClientLevel world, Camera camera, PoseStack matrixStack, MultiBufferSource consumer) {
        Direction endDir;
        BlockPos endBlockPos;
        boolean hasStart;
        if (world == null) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null || client.hitResult == null || client.hitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        BlockHitResult blockHit = (BlockHitResult)client.hitResult;
        if (!(stack.getItem() instanceof BeltItem)) {
            return;
        }
        boolean bl = hasStart = stack.has((DataComponentType)ComponentContent.BELT_START.get()) && stack.has((DataComponentType)ComponentContent.BELT_DIR.get());
        if (!hasStart) {
            Optional targetedChuteCandidate;
            BlockState startState;
            boolean couldBePlaced = false;
            BlockPos potentialStart = blockHit.getBlockPos().offset(blockHit.getDirection().getNormal());
            Direction startDir = blockHit.getDirection();
            if (blockHit.getDirection().getAxis().equals((Object)Direction.Axis.Y)) {
                startDir = player.getDirection().getOpposite();
            }
            if ((startState = world.getBlockState(potentialStart)).canBeReplaced() || startState.isAir()) {
                couldBePlaced = true;
            }
            if ((targetedChuteCandidate = world.getBlockEntity(blockHit.getBlockPos(), (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get())).isPresent()) {
                ChuteBlockEntity chuteEntity = (ChuteBlockEntity)((Object)targetedChuteCandidate.get());
                startDir = chuteEntity.getOwnFacing();
                potentialStart = blockHit.getBlockPos();
                couldBePlaced = true;
            }
            Vec3 boxDirectionOffset = Vec3.atLowerCornerOf((Vec3i)startDir.getNormal()).scale(0.1 + (double)((float)(world.getGameTime() % 10L) / 20.0f));
            Vec3 bowLower = potentialStart.getCenter().subtract(Vec3.atLowerCornerOf((Vec3i)startDir.getNormal()).scale((double)0.4f)).subtract((double)0.1f, (double)0.1f, (double)0.1f);
            Vec3 boxUpper = potentialStart.getCenter().subtract(Vec3.atLowerCornerOf((Vec3i)startDir.getNormal()).scale((double)0.4f)).add((double)0.1f, (double)0.1f, (double)0.1f).add(boxDirectionOffset);
            AABB box = new AABB(bowLower, boxUpper);
            matrixStack.pushPose();
            Vec3 cameraPos = camera.getPosition();
            matrixStack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
            LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)consumer.getBuffer(RenderType.lines()), (AABB)box, (float)(couldBePlaced ? 0.1f : 1.0f), (float)(couldBePlaced ? 0.8f : 0.1f), (float)(couldBePlaced ? 0.7f : 0.0f), (float)0.9f);
            matrixStack.popPose();
            return;
        }
        BlockPos startBlockPos = (BlockPos)stack.get((DataComponentType)ComponentContent.BELT_START.get());
        Direction startFacing = (Direction)stack.get((DataComponentType)ComponentContent.BELT_DIR.get());
        if (startBlockPos == null || startBlockPos.equals((Object)BlockPos.ZERO) || startFacing == null) {
            return;
        }
        Vec3 startPos = startBlockPos.getCenter();
        Vec3i startDir = startFacing.getNormal();
        List<Tuple<BlockPos, Direction>> midPoints = BeltItem.getStoredMidpoints(stack, (Level)world);
        Optional endChuteCandidate = world.getBlockEntity(blockHit.getBlockPos(), (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (endChuteCandidate.isPresent()) {
            ChuteBlockEntity endChute = (ChuteBlockEntity)((Object)endChuteCandidate.get());
            endBlockPos = blockHit.getBlockPos();
            endDir = endChute.getOwnFacing().getOpposite();
        } else if (world.getBlockState(blockHit.getBlockPos()).getBlock().equals(BlockContent.CONVEYOR_SUPPORT_BLOCK.get())) {
            BlockPos conveyorPos = blockHit.getBlockPos();
            Direction conveyorFacing = (Direction)world.getBlockState(blockHit.getBlockPos()).getValue((Property)HorizontalDirectionalBlock.FACING);
            Vec3i reversedConveyorFacing = conveyorFacing.getNormal().multiply(-1);
            BlockPos lastEnd = midPoints.isEmpty() ? startBlockPos : (BlockPos)midPoints.getLast().getA();
            double distA = conveyorPos.offset(conveyorFacing.getNormal()).distSqr((Vec3i)lastEnd);
            double distB = conveyorPos.offset(reversedConveyorFacing).distSqr((Vec3i)lastEnd);
            endDir = distB < distA ? conveyorFacing : conveyorFacing.getOpposite();
            endBlockPos = conveyorPos;
        } else {
            endBlockPos = blockHit.getBlockPos().offset(blockHit.getDirection().getNormal());
            endDir = blockHit.getDirection().getOpposite();
            if (endDir.getAxis().isVertical()) {
                endDir = player.getDirection().getOpposite();
            }
        }
        Vec3 visualEndPos = endBlockPos.getCenter();
        Vec3i visualEndDir = endDir.getNormal();
        matrixStack.pushPose();
        Vec3 cameraPos = camera.getPosition();
        matrixStack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        List<Vec3> linePoints = BeltOutlineRenderer.getPositionsAlongLine(startPos, visualEndPos, startDir, visualEndDir, midPoints);
        Vec3 lastForward = Vec3.atLowerCornerOf((Vec3i)startDir).normalize();
        Vec3 lastCenter = Vec3.ZERO;
        if (!linePoints.isEmpty()) {
            lastCenter = linePoints.getFirst();
        }
        for (Vec3 center : linePoints) {
            float lineRadius = 0.05f;
            Vec3 newForward = center.subtract(lastCenter).normalize();
            if (center.equals((Object)lastCenter)) {
                newForward = lastForward;
            }
            double curveFactor = newForward.distanceTo(lastForward);
            Vec3 color = new Vec3(1.0, 1.0, 1.0);
            if (curveFactor > 0.25) {
                color = new Vec3(1.0, (double)0.6f, (double)0.2f);
            }
            if (curveFactor > (double)0.43f) {
                color = new Vec3(1.0, 0.0, 0.0);
            }
            lastCenter = center;
            lastForward = MathHelpers.lerp(lastForward, newForward, 0.3f);
            LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)consumer.getBuffer(RenderType.lines()), (double)(center.x - (double)lineRadius), (double)(center.y - (double)lineRadius), (double)(center.z - (double)lineRadius), (double)(center.x + (double)lineRadius), (double)(center.y + (double)lineRadius), (double)(center.z + (double)lineRadius), (float)((float)color.x), (float)((float)color.y), (float)((float)color.z), (float)0.8f);
        }
        matrixStack.popPose();
    }

    private static List<Vec3> getPositionsAlongLine(Vec3 from, Vec3 to, Vec3i startDir, Vec3i endDir, List<Tuple<BlockPos, Direction>> midpoints) {
        float stepSize = 0.1f;
        ArrayList<Vec3> result = new ArrayList<Vec3>();
        List<Tuple<Vec3, Vec3>> transformedMidPoints = midpoints.stream().map(elem -> new Tuple((Object)((BlockPos)elem.getA()).getCenter(), (Object)Vec3.atLowerCornerOf((Vec3i)((Direction)elem.getB()).getNormal()))).toList();
        List<Tuple<Vec3, Vec3>> segmentPoints = SplineUtil.getPointPairs(from, Vec3.atLowerCornerOf((Vec3i)startDir), to, Vec3.atLowerCornerOf((Vec3i)endDir), transformedMidPoints);
        double dist = SplineUtil.getTotalLength(segmentPoints);
        float i = 0.0f;
        while ((double)i < dist) {
            double progress = (double)i / dist;
            Vec3 center = SplineUtil.getPositionOnSpline(from, Vec3.atLowerCornerOf((Vec3i)startDir), to, Vec3.atLowerCornerOf((Vec3i)endDir), midpoints, progress);
            result.add(center);
            i += stepSize;
        }
        return result;
    }
}

