/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.placer;

import alexthw.starbunclemania.starbuncle.placer.StarbyPlacerBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PlaceBlockGoal<T extends StarbyPlacerBehavior>
extends GoToPosGoal<T> {
    public PlaceBlockGoal(Starbuncle starbuncle, T behavior) {
        super(starbuncle, behavior, () -> !starbuncle.getHeldStack().isEmpty());
    }

    public void start() {
        super.start();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.STORING_ITEM;
    }

    @Nullable
    public BlockPos getDestination() {
        return ((StarbyPlacerBehavior)this.behavior).getValidStorePos(this.starbuncle.getHeldStack());
    }

    public boolean onDestinationReached() {
        Item item;
        if (this.starbuncle.getHeldStack().isEmpty() || !((item = this.starbuncle.getHeldStack().getItem()) instanceof BlockItem)) {
            return true;
        }
        BlockItem blockItem = (BlockItem)item;
        if (((StarbyPlacerBehavior)this.behavior).isBedPowered()) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("BedPowered", "Bed Powered, cannot place items"));
            return true;
        }
        BlockState toPlaceState = blockItem.getBlock().defaultBlockState();
        BlockState toReplaceState = this.starbuncle.level().getBlockState(this.targetPos);
        if (!toReplaceState.canBeReplaced() || !toPlaceState.canSurvive((LevelReader)this.starbuncle.level(), this.targetPos)) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("CannotPlaceBlock", "Cannot place block at " + this.targetPos.toString()));
            this.starbuncle.setBackOff(5 + this.starbuncle.level().random.nextInt(20));
            return true;
        }
        this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("Placing block", "Placing block " + String.valueOf(blockItem) + "at " + this.targetPos.toString()));
        if (this.starbuncle.level().setBlockAndUpdate(this.targetPos, toPlaceState)) {
            this.starbuncle.getHeldStack().shrink(1);
            return true;
        }
        return false;
    }
}

