/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.noexception;

import com.machinezoo.noexception.ExceptionHandler;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;

final class LoggingHandler
extends ExceptionHandler {
    private final Logger logger;
    private final Supplier<String> supplier;

    LoggingHandler(Logger logger, Supplier<String> supplier) {
        Objects.requireNonNull(logger);
        Objects.requireNonNull(supplier);
        this.logger = logger;
        this.supplier = supplier;
    }

    @Override
    public boolean handle(Throwable exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        String message = null;
        try {
            message = this.supplier.get();
        }
        catch (Throwable ex) {
            this.logger.error("Failed to produce log message.", ex);
        }
        if (message == null) {
            message = "Caught exception.";
        }
        this.logger.error(message, exception);
        return true;
    }
}

