/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AEApi;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemItemHandler;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.common.util.inventory.StorageProcessor;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MEItemHandler
implements IStorageSystemItemHandler {
    @NotNull
    private final MEStorage storageMonitor;
    @NotNull
    private final IActionSource actionSource;

    public MEItemHandler(@NotNull MEStorage storageMonitor, @NotNull IActionSource actionSource) {
        this.storageMonitor = storageMonitor;
        this.actionSource = actionSource;
    }

    @Override
    @NotNull
    public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
        AEItemKey itemKey = AEItemKey.of((ItemStack)stack);
        long inserted = this.storageMonitor.insert((AEKey)itemKey, (long)stack.getCount(), simulate ? Actionable.SIMULATE : Actionable.MODULATE, this.actionSource);
        return stack.copyWithCount(stack.getCount() - (int)inserted);
    }

    @Override
    public int extractItems(ItemFilter filter, StorageProcessor<ItemStack> processor, boolean simulate) {
        List<Pair<Long, AEItemKey>> itemKeys = AEApi.findAEStacksFromFilter(this.storageMonitor, filter);
        if (itemKeys.isEmpty()) {
            return 0;
        }
        int needs = filter.getCount();
        for (Pair<Long, AEItemKey> pair : itemKeys) {
            int extracted;
            AEItemKey itemKey = pair.right();
            int count = (int)this.storageMonitor.extract((AEKey)itemKey, (long)needs, Actionable.SIMULATE, this.actionSource);
            if (count == 0 || (extracted = processor.process(itemKey.toStack().copyWithCount(count))) == 0) continue;
            needs -= extracted;
            if (!simulate) {
                this.storageMonitor.extract((AEKey)itemKey, (long)extracted, Actionable.MODULATE, this.actionSource);
            }
            if (needs > 0) continue;
            break;
        }
        return filter.getCount() - needs;
    }
}

