/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.container.base;

import de.srendi.advancedperipherals.common.container.base.BaseContainer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public abstract class BaseScreen<T extends BaseContainer>
extends AbstractContainerScreen<T> {
    public BaseScreen(T screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.imageWidth = this.getSizeX();
        this.imageHeight = this.getSizeY();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        this.renderBackground(guiGraphics, x, y, partialTicks);
        super.render(guiGraphics, x, y, partialTicks);
        this.renderTooltip(guiGraphics, x, y);
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        guiGraphics.blit(this.getTexture(), this.getGuiLeft(), this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight);
    }

    public abstract int getSizeX();

    public abstract int getSizeY();

    public abstract ResourceLocation getTexture();
}

