/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.APAddon;
import de.srendi.advancedperipherals.common.util.DataComponentUtil;
import de.srendi.advancedperipherals.common.util.LRUCache;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalUtil;
import de.srendi.advancedperipherals.common.util.inventory.FluidUtil;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class LuaConverter {
    private static final LRUCache<ResourceKey<?>, List<String>> HOLDER2TAGS_CACHE = new LRUCache(512);
    private static final LRUCache<TagKey<?>, String> TAG2STRING_CACHE = new LRUCache(1024);
    private static final LRUCache<ResourceKey<?>, String> REGISTRY2SLASH_STRING_CACHE = new LRUCache(256);

    public static Map<String, Object> entityToLua(Entity entity) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", entity.getId());
        data.put("uuid", entity.getStringUUID());
        data.put("name", entity.getName().getString());
        data.put("tags", entity.getTags());
        data.put("canFreeze", entity.canFreeze());
        data.put("isGlowing", entity.isCurrentlyGlowing());
        data.put("isInWall", entity.isInWall());
        return data;
    }

    public static Map<String, Object> livingEntityToLua(LivingEntity entity) {
        Map<String, Object> data = LuaConverter.entityToLua((Entity)entity);
        data.put("health", Float.valueOf(entity.getHealth()));
        data.put("maxHealth", Float.valueOf(entity.getMaxHealth()));
        data.put("lastDamageSource", entity.getLastDamageSource() == null ? null : entity.getLastDamageSource().toString());
        return data;
    }

    public static Map<String, Object> animalToLua(Animal animal, ItemStack itemInHand) {
        Map<String, Object> data = LuaConverter.livingEntityToLua((LivingEntity)animal);
        data.put("baby", animal.isBaby());
        data.put("inLove", animal.isInLove());
        data.put("aggressive", animal.isAggressive());
        if (animal instanceof IShearable) {
            IShearable shareable = (IShearable)animal;
            if (!itemInHand.isEmpty()) {
                data.put("shareable", shareable.isShearable(null, itemInHand, animal.level(), animal.blockPosition()));
            }
        }
        return data;
    }

    public static Map<String, Object> completeEntityToLua(Entity entity, ItemStack itemInHand) {
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            return LuaConverter.animalToLua(animal, itemInHand);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return LuaConverter.livingEntityToLua(livingEntity);
        }
        return LuaConverter.entityToLua(entity);
    }

    public static Map<String, Object> completeEntityWithPositionToLua(Entity entity, ItemStack itemInHand, BlockPos pos) {
        Map<String, Object> data = LuaConverter.completeEntityToLua(entity, itemInHand);
        data.put("x", entity.getX() - (double)pos.getX());
        data.put("y", entity.getY() - (double)pos.getY());
        data.put("z", entity.getZ() - (double)pos.getZ());
        return data;
    }

    public static Object stateToObject(Comparable<?> blockStateValue) {
        if (blockStateValue == null) {
            return null;
        }
        if (blockStateValue instanceof Boolean || blockStateValue instanceof Number || blockStateValue instanceof String) {
            return blockStateValue;
        }
        if (blockStateValue instanceof StringRepresentable) {
            StringRepresentable stringRepresentable = (StringRepresentable)blockStateValue;
            return stringRepresentable.getSerializedName();
        }
        return null;
    }

    public static Object posToObject(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        HashMap<String, Integer> properties = new HashMap<String, Integer>(3);
        properties.put("x", pos.getX());
        properties.put("y", pos.getY());
        properties.put("z", pos.getZ());
        return properties;
    }

    public static Map<String, Object> itemStackToObject(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        Map<String, Object> properties = LuaConverter.itemToObject(stack.getItem());
        DataComponentPatch components = stack.getComponentsPatch();
        properties.put("count", stack.getCount());
        properties.put("displayName", stack.getDisplayName().getString());
        properties.put("maxStackSize", stack.getMaxStackSize());
        try {
            properties.put("components", NBTUtil.toLua((Tag)DataComponentUtil.toNbt(components)));
        }
        catch (IllegalStateException ex) {
            AdvancedPeripherals.debug("Couldn't create components for Item Stack " + String.valueOf(stack), ex);
        }
        properties.put("fingerprint", ItemUtil.getFingerprint(stack));
        return properties;
    }

    public static Map<String, Object> itemStackToObject(@NotNull ItemStack stack, Level level) {
        if (stack.isEmpty()) {
            return null;
        }
        Map<String, Object> properties = LuaConverter.itemToObject(stack.getItem());
        DataComponentPatch components = stack.getComponentsPatch();
        properties.put("count", stack.getCount());
        properties.put("displayName", stack.getDisplayName().getString());
        properties.put("maxStackSize", stack.getMaxStackSize());
        try {
            properties.put("components", NBTUtil.toLua((Tag)DataComponentUtil.toNbt(components, level)));
        }
        catch (IllegalStateException ex) {
            AdvancedPeripherals.debug("Couldn't create components for Item Stack " + String.valueOf(stack), ex);
        }
        properties.put("fingerprint", ItemUtil.getFingerprint(stack));
        return properties;
    }

    public static Map<String, Object> fluidStackToObject(@NotNull FluidStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        Map<String, Object> properties = LuaConverter.fluidToObject(stack.getFluid());
        DataComponentPatch components = stack.getComponentsPatch();
        properties.put("count", stack.getAmount());
        properties.put("displayName", stack.getHoverName().getString());
        properties.put("fluidType", LuaConverter.fluidTypeToObject(stack.getFluidType()));
        properties.put("components", NBTUtil.toLua((Tag)DataComponentUtil.toNbt(components)));
        properties.put("fingerprint", FluidUtil.getFingerprint(stack));
        return properties;
    }

    public static Map<String, Object> chemicalStackToObject(@NotNull ChemicalStack stack) {
        if (!APAddon.MEKANISM.isLoaded()) {
            return null;
        }
        if (stack.isEmpty()) {
            return null;
        }
        Map<String, Object> properties = LuaConverter.chemicalToObject(stack.getChemical());
        properties.put("count", stack.getAmount());
        properties.put("displayName", stack.getTextComponent().getString());
        properties.put("fingerprint", ChemicalUtil.getFingerprint(stack));
        return properties;
    }

    public static Map<String, Object> fluidTypeToObject(FluidType type) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("viscosity", type.getViscosity());
        properties.put("density", type.getDensity());
        properties.put("canHydrate", type.canHydrate((Entity)null));
        properties.put("canExtinguish", type.canExtinguish(null));
        properties.put("canDrownIn", type.canDrownIn(null));
        properties.put("canSwim", type.canSwim(null));
        properties.put("canPushEntity", type.canPushEntity(null));
        properties.put("supportsBoating", type.supportsBoating(null));
        properties.put("canConvertToSource", type.canConvertToSource(null));
        properties.put("temperature", type.getTemperature(null));
        return properties;
    }

    public static Map<String, Object> itemStackToObject(@NotNull ItemStack itemStack, long count) {
        if (itemStack.isEmpty()) {
            return null;
        }
        Map<String, Object> properties = LuaConverter.itemStackToObject(itemStack);
        properties.put("count", count);
        return properties;
    }

    public static Map<String, Object> fluidStackToObject(@NotNull FluidStack fluidStack, long count) {
        if (fluidStack.isEmpty()) {
            return null;
        }
        Map<String, Object> properties = LuaConverter.fluidStackToObject(fluidStack);
        properties.put("count", count);
        return properties;
    }

    public static Map<String, Object> chemicalStackToObject(@NotNull ChemicalStack chemicalStack, long count) {
        if (!APAddon.MEKANISM.isLoaded()) {
            return null;
        }
        if (chemicalStack.isEmpty()) {
            return null;
        }
        Map<String, Object> properties = LuaConverter.chemicalStackToObject(chemicalStack);
        properties.put("count", count);
        return properties;
    }

    public static Map<String, Object> stackToObjectWithSlot(@NotNull ItemStack stack, int slot) {
        if (stack.isEmpty()) {
            return null;
        }
        Map<String, Object> properties = LuaConverter.itemStackToObject(stack);
        properties.put("slot", slot);
        return properties;
    }

    public static Map<String, Object> itemToObject(@NotNull Item item) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("tags", LuaConverter.getHolderTags(item.builtInRegistryHolder()));
        properties.put("name", ItemUtil.getRegistryKey(item).toString());
        return properties;
    }

    public static Map<String, Object> fluidToObject(@NotNull Fluid fluid) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("tags", LuaConverter.getHolderTags(fluid.builtInRegistryHolder()));
        properties.put("name", FluidUtil.getRegistryKey(fluid).toString());
        return properties;
    }

    public static Map<String, Object> chemicalToObject(@NotNull Chemical chemical) {
        if (!APAddon.MEKANISM.isLoaded()) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("tags", LuaConverter.getHolderTags(MekanismAPI.CHEMICAL_REGISTRY.wrapAsHolder((Object)chemical)));
        properties.put("isGaseous", chemical.isGaseous());
        properties.put("radioactivity", chemical.isRadioactive());
        properties.put("name", ChemicalUtil.getRegistryKey(chemical).toString());
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<String> getHolderTags(Holder<T> holder) {
        ResourceKey holderKey = holder.unwrapKey().orElse(null);
        if (holderKey == null) {
            return LuaConverter.tagsToList(holder.tags());
        }
        LRUCache<ResourceKey<?>, List<String>> lRUCache = HOLDER2TAGS_CACHE;
        synchronized (lRUCache) {
            return HOLDER2TAGS_CACHE.computeIfAbsent(holderKey, k -> LuaConverter.tagsToList(holder.tags()));
        }
    }

    public static <T> List<String> tagsToList(Stream<TagKey<T>> tags) {
        return tags.map(LuaConverter::tagToString).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tagToString(@NotNull TagKey<?> tag) {
        LRUCache<TagKey<?>, String> lRUCache = TAG2STRING_CACHE;
        synchronized (lRUCache) {
            return TAG2STRING_CACHE.computeIfAbsent(tag, t -> LuaConverter.registryToSlashString(t.registry()) + t.location().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String registryToSlashString(ResourceKey<? extends Registry<?>> key) {
        LRUCache<ResourceKey<?>, String> lRUCache = REGISTRY2SLASH_STRING_CACHE;
        synchronized (lRUCache) {
            return REGISTRY2SLASH_STRING_CACHE.computeIfAbsent(key, k -> k.location().toString() + "/");
        }
    }

    public static BlockPos convertToBlockPos(Map<?, ?> table) throws LuaException {
        Number y;
        Number x;
        Object obj;
        block5: {
            block4: {
                if (!(table.containsKey("x") && table.containsKey("y") && table.containsKey("z"))) {
                    throw new LuaException("Table should be block position table");
                }
                obj = table.get("x");
                if (!(obj instanceof Number)) break block4;
                x = (Number)obj;
                obj = table.get("y");
                if (!(obj instanceof Number)) break block4;
                y = (Number)obj;
                obj = table.get("z");
                if (obj instanceof Number) break block5;
            }
            throw new LuaException("Table should be block position table");
        }
        Number z = (Number)obj;
        return new BlockPos(x.intValue(), y.intValue(), z.intValue());
    }

    public static BlockPos convertToBlockPos(BlockPos center, Map<?, ?> table) throws LuaException {
        BlockPos relative = LuaConverter.convertToBlockPos(table);
        return new BlockPos(center.getX() + relative.getX(), center.getY() + relative.getY(), center.getZ() + relative.getZ());
    }
}

