/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.particle.client;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;

public class MagicParticle
extends TextureSheetParticle {
    final float origSize;

    public MagicParticle(ClientLevel worldIn, double x, double y, double z, SpriteSet sprite) {
        super(worldIn, x, y, z, 0.0, 0.0, 0.0);
        this.setColor(1.0f, 1.0f, 1.0f);
        this.xd *= (double)0.05f;
        this.yd -= 0.5;
        this.yd *= (double)0.05f;
        this.zd *= (double)0.05f;
        this.lifetime = 20;
        this.origSize = this.quadSize /= 2.0f;
        this.pickSprite(sprite);
    }

    public void tick() {
        super.tick();
        this.xd *= (double)0.65f;
        this.yd *= (double)0.65f;
        this.zd *= (double)0.65f;
        if (this.random.nextInt(4) == 0) {
            --this.age;
        }
        this.quadSize = (1.0f - (float)this.age / (float)this.lifetime) * this.origSize;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public boolean isAlive() {
        return this.age < this.lifetime;
    }

    protected int getLightColor(float f) {
        return 0xF000F0;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Provider(SpriteSet spriteSet) {
            this.spriteProvider = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType particleOptions, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i) {
            MagicParticle particle = new MagicParticle(clientLevel, d, e, f, this.spriteProvider);
            particle.setAlpha(1.0f);
            return particle;
        }
    }
}

