/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.viewers.jei.categories;

import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.attachments.PlayerStageAttachment;
import tv.soaryn.xycraft.core.content.attachments.accessors.FavoredColor;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContent;
import tv.soaryn.xycraft.core.content.recipe.IRecipeWithStage;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.ui.NineSlicedResource;
import tv.soaryn.xycraft.core.ui.Rectangle;
import tv.soaryn.xycraft.core.ui.oldwidget.WindowWidget;
import tv.soaryn.xycraft.core.utils.Utils;

public abstract class XyCategory<T extends IRecipeContent<?, ?> & IRecipeWithStage>
implements IRecipeCategory<T> {
    public final IGuiHelper _guiHelper;
    private final RecipeType<T> _type;
    private final String _translationKey;
    private final IDrawable _icon;
    private final IDrawableStatic _background;
    private final Rectangle _dimensions;
    private static final NineSlicedResource Background = new NineSlicedResource(XyCore.resource((String)"textures/gui/sliced/border.png"));
    public static final NineSlicedResource slotUi = new NineSlicedResource(XyCore.resource((String)"textures/gui/sliced/slot.png"));
    private final WindowWidget ColorableWindow;

    public XyCategory(String translationKey, IGuiHelper guiHelper, RecipeType<T> type, IDrawable icon, IDrawableStatic background, Rectangle dimensions) {
        this._guiHelper = guiHelper;
        this._type = type;
        this._translationKey = translationKey;
        this._icon = icon;
        this._background = background;
        this._dimensions = dimensions;
        this.ColorableWindow = new WindowWidget(null, Background, 0.0f, 0.0f, dimensions.width() + 16.0f, dimensions.height() + 12.0f, XyCraftColors.Blue.getColor());
    }

    static void handleOutputSlot(@NotNull IRecipeLayoutBuilder builder, int x, int y, Either<FluidStack, ItemStack> either) {
        either.map(left -> {
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addFluidStack(left.getFluid(), (long)left.getAmount(), left.getComponentsPatch()).setFluidRenderer(1L, false, 16, 16);
            return true;
        }, right -> {
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(right);
            return true;
        });
    }

    static void handleInputSlot(@NotNull IRecipeLayoutBuilder builder, int x, int y, Either<SizedFluidIngredient, SizedIngredient> either) {
        either.map(left -> {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.asList(left.getFluids()))).setFluidRenderer(1L, false, 16, 16);
            return true;
        }, right -> {
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(right.ingredient());
            return true;
        });
    }

    static void handleUnresearchedInput(@NotNull IRecipeLayoutBuilder builder, Either<SizedFluidIngredient, SizedIngredient> input) {
        input.map(left -> {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.asList(left.getFluids()));
            return true;
        }, right -> {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredients(right.ingredient());
            return true;
        });
    }

    static void handleUnresearchedOutput(@NotNull IRecipeLayoutBuilder builder, Either<FluidStack, ItemStack> input) {
        input.map(left -> {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addFluidStack(left.getFluid(), (long)left.getAmount(), left.getComponentsPatch());
            return true;
        }, right -> {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(right);
            return true;
        });
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)this._translationKey);
    }

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this._type;
    }

    @NotNull
    public IDrawable getIcon() {
        return this._icon;
    }

    @NotNull
    public IDrawable getBackground() {
        return this._background;
    }

    public Rectangle getDimensions() {
        return this._dimensions;
    }

    public void drawSlots(@NotNull T recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
    }

    public void draw(@NotNull T recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Player player = Utils.getClientPlayer();
        this.ColorableWindow.setColor(FavoredColor.of((IAttachmentHolder)player));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(-8.0f, -6.0f, 0.0f);
        this.ColorableWindow.render(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
        guiGraphics.pose().popPose();
        if (((IRecipeWithStage)recipe).getRequiredStage().isPresent() && player != null) {
            Optional stage = ((IRecipeWithStage)recipe).getRequiredStage();
            PlayerStageAttachment data = (PlayerStageAttachment)player.getData(CoreAttachments.PlayerStageData);
            if (!data.stages().getOrDefault(stage.get(), false)) {
                int x = 12;
                int y = 12;
                int wrapping = 116;
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"jei.xycraft.recipe.general.requirement.locked"), x, y, 0xF0F0F0);
                guiGraphics.drawWordWrap(Minecraft.getInstance().font, FormattedText.of((String)((IStage)stage.get()).presentedLabel().getString(), (Style)Style.EMPTY.withColor(8409120)), x + 1, y + 16, wrapping, -1);
                guiGraphics.drawWordWrap(Minecraft.getInstance().font, FormattedText.of((String)((IStage)stage.get()).presentedLabel().getString(), (Style)Style.EMPTY.withColor(16765104)), x, y + 15, wrapping, -1);
                return;
            }
        }
        this.drawSlots(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public boolean isHandled(@NotNull T recipe) {
        Player player = Utils.getClientPlayer();
        if (player == null) {
            return true;
        }
        Optional stageOptional = ((IRecipeWithStage)recipe).getRequiredStage();
        if (stageOptional.isEmpty()) {
            return true;
        }
        return true;
    }
}

