/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.atmospheric;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.content.recipe.IRecipeBuilder;
import tv.soaryn.xycraft.machines.content.recipes.producers.atmospheric.AtmosphericVacuumRecipe;

public class AtmosphericVacuumRecipeBuilder
implements IRecipeBuilder.WithItem.Output<AtmosphericVacuumRecipeBuilder, AtmosphericVacuumRecipe>,
IRecipeBuilder.WithFluid.Output<AtmosphericVacuumRecipeBuilder, AtmosphericVacuumRecipe>,
IRecipeBuilder.WithStage<AtmosphericVacuumRecipeBuilder, AtmosphericVacuumRecipe> {
    private TagKey<Biome> _biome = null;
    private Either<FluidStack, ItemStack> _output = null;
    private long _ticks;
    private Optional<IStage> _requiredStage = Optional.empty();

    public static AtmosphericVacuumRecipeBuilder create() {
        return (AtmosphericVacuumRecipeBuilder)new AtmosphericVacuumRecipeBuilder().seconds(5L);
    }

    public AtmosphericVacuumRecipeBuilder input(TagKey<Biome> biome) {
        this._biome = biome;
        return this;
    }

    public AtmosphericVacuumRecipeBuilder output(FluidStack outputIngredient) {
        if (this._output != null) {
            throw new IllegalArgumentException("Too many outputs in Atmospheric Vacuum Recipe!");
        }
        this._output = Either.left((Object)outputIngredient);
        return this;
    }

    public AtmosphericVacuumRecipeBuilder output(ItemStack output) {
        if (this._output != null) {
            throw new IllegalArgumentException("Too many outputs in Atmospheric Vacuum Recipe!");
        }
        this._output = Either.right((Object)output);
        return this;
    }

    @NotNull
    public AtmosphericVacuumRecipeBuilder ticks(long ticks) {
        this._ticks = ticks;
        return this;
    }

    @NotNull
    public AtmosphericVacuumRecipe makeRecipe() {
        return new AtmosphericVacuumRecipe(this._biome, this._output, this._ticks, this._requiredStage);
    }

    public void ensureValid(String id) {
        if (this._biome == null) {
            throw new RuntimeException("Biome tag is null in Atmospheric Vacuum recipe - " + id);
        }
        if (this._output == null) {
            throw new RuntimeException("No output in Atmospheric Vacuum recipe - " + id);
        }
        if (this._ticks <= 0L) {
            throw new RuntimeException("No ticks in Atmospheric Vacuum recipe - " + id);
        }
    }

    @NotNull
    public AtmosphericVacuumRecipeBuilder requires(IStage stage) {
        this._requiredStage = Optional.of(stage);
        return this;
    }
}

