/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.packet;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class PacketSender {
    public static Packet<?> toClientPacket(CustomPacketPayload payload) {
        return new ClientboundCustomPayloadPacket(payload);
    }

    public static void sendToPlayer(CustomPacketPayload payload, @Nullable ServerPlayer player) {
        PacketSender.sendToPlayer(PacketSender.toClientPacket(payload), player);
    }

    public static void sendToPlayer(Packet<?> packet, @Nullable ServerPlayer player) {
        if (player == null) {
            PacketSender.sendToAllPlayers(packet);
        } else {
            player.connection.send(packet);
        }
    }

    public static void sendToAllPlayers(CustomPacketPayload payload) {
        PacketSender.sendToAllPlayers(PacketSender.toClientPacket(payload));
    }

    public static void sendToAllPlayers(Packet<?> packet) {
        ServerLifecycleHooks.getCurrentServer().getPlayerList().broadcastAll(packet);
    }

    public static void sendToAllAround(CustomPacketPayload payload, BlockPos pos, double range, ResourceKey<Level> dim) {
        PacketSender.sendToAllAround(PacketSender.toClientPacket(payload), pos, range, dim);
    }

    public static void sendToAllAround(Packet<?> packet, BlockPos pos, double range, ResourceKey<Level> dim) {
        PacketSender.sendToAllAround(packet, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), range, dim);
    }

    public static void sendToAllAround(CustomPacketPayload payload, double x, double y, double z, double range, ResourceKey<Level> dim) {
        PacketSender.sendToAllAround(PacketSender.toClientPacket(payload), x, y, z, range, dim);
    }

    public static void sendToAllAround(Packet<?> packet, double x, double y, double z, double range, ResourceKey<Level> dim) {
        ServerLifecycleHooks.getCurrentServer().getPlayerList().broadcast(null, x, y, z, range, dim, packet);
    }

    public static void sendToDimension(CustomPacketPayload payload, ResourceKey<Level> dim) {
        PacketSender.sendToDimension(PacketSender.toClientPacket(payload), dim);
    }

    public static void sendToDimension(Packet<?> packet, ResourceKey<Level> dim) {
        ServerLifecycleHooks.getCurrentServer().getPlayerList().broadcastAll(packet, dim);
    }

    public static void sendToChunk(CustomPacketPayload payload, BlockEntity tile) {
        PacketSender.sendToChunk(PacketSender.toClientPacket(payload), tile);
    }

    public static void sendToChunk(Packet<?> packet, BlockEntity tile) {
        PacketSender.sendToChunk(packet, (ServerLevel)Objects.requireNonNull(tile.getLevel()), tile.getBlockPos());
    }

    public static void sendToChunk(CustomPacketPayload payload, ServerLevel level, BlockPos pos) {
        PacketSender.sendToChunk(PacketSender.toClientPacket(payload), level, pos);
    }

    public static void sendToChunk(Packet<?> packet, ServerLevel level, BlockPos pos) {
        PacketSender.sendToChunk(packet, level, pos.getX() >> 4, pos.getZ() >> 4);
    }

    public static void sendToChunk(CustomPacketPayload payload, ServerLevel level, int chunkX, int chunkZ) {
        PacketSender.sendToChunk(PacketSender.toClientPacket(payload), level, chunkX, chunkZ);
    }

    public static void sendToChunk(Packet<?> packet, ServerLevel level, int chunkX, int chunkZ) {
        PacketSender.sendToChunk(packet, level, new ChunkPos(chunkX, chunkZ));
    }

    public static void sendToChunk(CustomPacketPayload payload, ServerLevel level, ChunkPos pos) {
        PacketSender.sendToChunk(PacketSender.toClientPacket(payload), level, pos);
    }

    public static void sendToChunk(Packet<?> packet, ServerLevel level, ChunkPos pos) {
        level.getChunkSource().chunkMap.getPlayers(pos, false).forEach(e -> PacketSender.sendToPlayer(packet, e));
    }

    public static void sendToOps(CustomPacketPayload payload) {
        PacketSender.sendToOps(PacketSender.toClientPacket(payload));
    }

    public static void sendToOps(Packet<?> packet) {
        PlayerList playerList = ServerLifecycleHooks.getCurrentServer().getPlayerList();
        ServerOpList opList = playerList.getOps();
        for (ServerPlayer player : playerList.getPlayers()) {
            if (opList.get((Object)player.getGameProfile()) == null) continue;
            PacketSender.sendToPlayer(packet, player);
        }
    }

    public static Packet<?> toServerPacket(CustomPacketPayload payload) {
        return new ServerboundCustomPayloadPacket(payload);
    }

    public static void sendToServer(CustomPacketPayload payload) {
        PacketSender.sendToServer(PacketSender.toServerPacket(payload));
    }

    public static void sendToServer(Packet<?> packet) {
        Objects.requireNonNull(Minecraft.getInstance().getConnection()).send(packet);
    }
}

