/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection;
import dev.ftb.mods.ftbteams.data.AbstractTeam;
import dev.ftb.mods.ftbteams.data.TeamPropertyCollectionImpl;
import dev.ftb.mods.ftbteams.net.UpdatePropertiesResponseMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public record UpdatePropertiesRequestMessage(TeamPropertyCollection properties) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdatePropertiesRequestMessage> TYPE = new CustomPacketPayload.Type(FTBTeamsAPI.rl("update_properties_request"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdatePropertiesRequestMessage> STREAM_CODEC = StreamCodec.composite(TeamPropertyCollectionImpl.STREAM_CODEC, UpdatePropertiesRequestMessage::properties, UpdatePropertiesRequestMessage::new);

    public static void handle(UpdatePropertiesRequestMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            FTBTeamsAPI.api().getManager().getTeamForPlayer(player).ifPresent(team -> {
                AbstractTeam abstractTeam;
                if (team instanceof AbstractTeam && (abstractTeam = (AbstractTeam)team).isOfficerOrBetter(player.getUUID())) {
                    abstractTeam.updatePropertiesFrom(message.properties.copyIf(TeamProperty::isPlayerEditable));
                    NetworkHelper.sendToAll((MinecraftServer)player.server, (CustomPacketPayload)new UpdatePropertiesResponseMessage(team.getId(), abstractTeam.getProperties()));
                }
            });
        });
    }

    public CustomPacketPayload.Type<UpdatePropertiesRequestMessage> type() {
        return TYPE;
    }
}

