/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import mekanism.api.functions.ByteSupplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedValue;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CachedByteValue
extends CachedValue<Byte>
implements ByteSupplier {
    private boolean resolved;
    private byte cachedValue;

    private CachedByteValue(IMekanismConfig config, ModConfigSpec.ConfigValue<Byte> internal) {
        super(config, internal);
    }

    public static CachedByteValue wrap(IMekanismConfig config, ModConfigSpec.ConfigValue<Byte> internal) {
        return new CachedByteValue(config, internal);
    }

    public byte getOrDefault() {
        if (this.resolved || this.isLoaded()) {
            return this.get();
        }
        return (Byte)this.internal.getDefault();
    }

    public byte get() {
        if (!this.resolved) {
            this.cachedValue = (Byte)this.internal.get();
            this.resolved = true;
        }
        return this.cachedValue;
    }

    @Override
    public byte getAsByte() {
        return this.get();
    }

    public void set(byte value) {
        this.internal.set((Object)value);
        this.cachedValue = value;
    }

    @Override
    protected boolean clearCachedValue(boolean checkChanged) {
        if (!this.resolved) {
            return false;
        }
        byte oldCachedValue = this.cachedValue;
        this.resolved = false;
        return checkChanged && oldCachedValue != this.get();
    }
}

