/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.ArrayList;
import java.util.function.Consumer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.radial.mode.NestedRadialMode;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.lib.radial.IGenericRadialModeItem;
import mekanism.common.lib.radial.data.NestingRadialData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface IRadialModuleContainerItem
extends IModuleContainerItem,
IGenericRadialModeItem {
    public ResourceLocation getRadialIdentifier();

    @Override
    @Nullable
    default public RadialData<?> getRadialData(ItemStack stack) {
        ArrayList<NestedRadialMode> nestedModes = new ArrayList<NestedRadialMode>();
        Consumer<NestedRadialMode> adder = nestedModes::add;
        for (IModule<?> module : this.getModules(stack)) {
            if (!module.handlesRadialModeChange()) continue;
            IRadialModuleContainerItem.addRadialModes(module, stack, adder);
        }
        if (nestedModes.isEmpty()) {
            return null;
        }
        if (nestedModes.size() == 1) {
            return ((NestedRadialMode)nestedModes.getFirst()).nestedData();
        }
        return new NestingRadialData(this.getRadialIdentifier(), nestedModes);
    }

    @Override
    @Nullable
    default public <M extends IRadialMode> M getMode(ItemStack stack, RadialData<M> radialData) {
        for (IModule<?> module : this.getModules(stack)) {
            M mode;
            if (!module.handlesRadialModeChange() || (mode = IRadialModuleContainerItem.getMode(module, stack, radialData)) == null) continue;
            return mode;
        }
        return null;
    }

    @Override
    default public <M extends IRadialMode> void setMode(ItemStack stack, Player player, RadialData<M> radialData, M mode) {
        IModuleContainer moduleContainer = this.moduleContainer(stack);
        if (moduleContainer != null) {
            for (IModule<?> module : moduleContainer.modules()) {
                if (!module.handlesRadialModeChange() || !IRadialModuleContainerItem.setMode(module, player, moduleContainer, stack, radialData, mode)) continue;
                return;
            }
        }
    }

    private static <MODULE extends ICustomModule<MODULE>> void addRadialModes(IModule<MODULE> module, ItemStack stack, Consumer<NestedRadialMode> adder) {
        module.getCustomInstance().addRadialModes(module, stack, adder);
    }

    @Nullable
    private static <M extends IRadialMode, MODULE extends ICustomModule<MODULE>> M getMode(IModule<MODULE> module, ItemStack stack, RadialData<M> radialData) {
        return module.getCustomInstance().getMode(module, stack, radialData);
    }

    private static <M extends IRadialMode, MODULE extends ICustomModule<MODULE>> boolean setMode(IModule<MODULE> module, Player player, IModuleContainer moduleContainer, ItemStack stack, RadialData<M> radialData, M mode) {
        return module.getCustomInstance().setMode(module, player, moduleContainer, stack, radialData, mode);
    }
}

