/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.interfaces;

import mekanism.common.capabilities.IOffsetCapability;
import mekanism.common.tile.interfaces.IComparatorSupport;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IBoundingBlock
extends IComparatorSupport,
IOffsetCapability,
IUpgradeTile {
    default public void onBoundingBlockPowerChange(BlockPos boundingPos, int oldLevel, int newLevel) {
    }

    default public int getBoundingComparatorSignal(Vec3i offset) {
        return 0;
    }

    default public boolean triggerBoundingEvent(Vec3i offset, int id, int param) {
        return false;
    }

    @Override
    default public boolean isOffsetCapabilityDisabled(@NotNull BlockCapability<?, @Nullable Direction> capability, Direction side, @NotNull Vec3i offset) {
        return true;
    }

    @Override
    @Nullable
    default public <T> T getOffsetCapabilityIfEnabled(@NotNull BlockCapability<T, @Nullable Direction> capability, Direction side, @NotNull Vec3i offset) {
        T t;
        IBoundingBlock iBoundingBlock = this;
        if (iBoundingBlock instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)iBoundingBlock;
            t = WorldUtils.getCapability(be.getLevel(), capability, be.getBlockPos(), null, be, side);
        } else {
            t = null;
        }
        return t;
    }
}

