/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.laser;

import java.util.Comparator;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.lasers.ILaserDissipation;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.api.math.MathUtils;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.advancements.triggers.BlockLaserTrigger;
import mekanism.common.advancements.triggers.MekanismDamageTrigger;
import mekanism.common.base.MekFakePlayer;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.item.gear.ItemAtomicDisassembler;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.PacketHitBlockEffect;
import mekanism.common.particle.LaserParticleData;
import mekanism.common.registries.MekanismDamageTypes;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;

public abstract class TileEntityBasicLaser
extends TileEntityMekanism {
    protected LaserEnergyContainer energyContainer;
    @SyntheticComputerMethod(getter="getDiggingPos")
    private BlockPos digging;
    private long diggingProgress = 0L;
    private long lastFired = 0L;

    public TileEntityBasicLaser(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this.facingSupplier);
        this.addInitialEnergyContainers(builder, listener);
        return builder.build();
    }

    protected abstract void addInitialEnergyContainers(EnergyContainerHelper var1, IContentsListener var2);

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        long firing = this.energyContainer.extract(this.toFire(), Action.SIMULATE, AutomationType.INTERNAL);
        if (firing > 0L) {
            Pos3D to;
            Pos3D from;
            if (firing != this.lastFired || !this.getActive()) {
                this.setActive(true);
                this.lastFired = firing;
                sendUpdatePacket = true;
            }
            Direction direction = this.getDirection();
            Level level = this.getWorldNN();
            BlockHitResult result = level.clip(new ClipContext((Vec3)(from = Pos3D.create(this).centre().translate(direction, 0.501)), (Vec3)(to = from.translate(direction, (double)MekanismConfig.general.laserRange.get() - 0.002)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, CollisionContext.empty()));
            if (result.getType() != HitResult.Type.MISS) {
                to = new Pos3D(result.getLocation());
            }
            float laserEnergyScale = this.getEnergyScale(firing);
            long remainingEnergy = firing;
            List hitEntities = level.getEntitiesOfClass(Entity.class, this.getLaserBox(direction, from, to, laserEnergyScale));
            if (hitEntities.isEmpty()) {
                this.setEmittingRedstone(false);
            } else {
                this.setEmittingRedstone(true);
                Pos3D finalFrom = from;
                hitEntities.sort(Comparator.comparingDouble(entity -> entity.distanceToSqr((Vec3)finalFrom)));
                long energyPerDamage = MekanismConfig.general.laserEnergyPerDamage.get();
                AABB adjustedAABB = null;
                for (Entity entity2 : hitEntities) {
                    float energyScale;
                    ItemEntity item;
                    if (adjustedAABB != null && !entity2.getBoundingBox().intersects(adjustedAABB)) continue;
                    if (entity2.isInvulnerableTo(MekanismDamageTypes.LASER.source(level))) {
                        remainingEnergy = 0L;
                        to = from.adjustPosition(direction, entity2);
                        break;
                    }
                    if (entity2 instanceof ItemEntity && this.handleHitItem(item = (ItemEntity)entity2)) continue;
                    boolean updateEnergyScale = false;
                    double value = (double)remainingEnergy / (double)energyPerDamage;
                    float damage = (float)value;
                    float health = 0.0f;
                    if (entity2 instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity2;
                        boolean updateDamage = false;
                        float damageBlocked = this.damageShield(level, livingEntity, from, damage);
                        if (damageBlocked > 0.0f) {
                            if (livingEntity instanceof ServerPlayer) {
                                ServerPlayer player = (ServerPlayer)livingEntity;
                                ((BlockLaserTrigger)((Object)MekanismCriteriaTriggers.BLOCK_LASER.value())).trigger(player);
                            }
                            if ((remainingEnergy -= MathUtils.clampToLong((float)energyPerDamage * damageBlocked)) == 0L) {
                                to = from.adjustPosition(direction, entity2);
                                break;
                            }
                            updateDamage = true;
                        }
                        double dissipationPercent = 0.0;
                        double refractionPercent = 0.0;
                        for (ItemStack armor : livingEntity.getArmorSlots()) {
                            ILaserDissipation laserDissipation;
                            if (armor.isEmpty() || (laserDissipation = (ILaserDissipation)armor.getCapability(Capabilities.LASER_DISSIPATION)) == null) continue;
                            dissipationPercent += laserDissipation.getDissipationPercent();
                            refractionPercent += laserDissipation.getRefractionPercent();
                            if (!(dissipationPercent >= 1.0)) continue;
                            break;
                        }
                        if (dissipationPercent > 0.0) {
                            if ((remainingEnergy = (long)((double)remainingEnergy * (1.0 - (dissipationPercent = Math.min(dissipationPercent, 1.0))))) == 0L) {
                                to = from.adjustPosition(direction, entity2);
                                break;
                            }
                            updateDamage = true;
                        }
                        if (refractionPercent > 0.0) {
                            refractionPercent = Math.min(refractionPercent, 1.0);
                            double refractedEnergy = (double)remainingEnergy * refractionPercent;
                            value = ((double)remainingEnergy - refractedEnergy) / (double)energyPerDamage;
                            damage = (float)value;
                            updateDamage = false;
                            updateEnergyScale = true;
                        }
                        if (updateDamage) {
                            value = (double)remainingEnergy / (double)energyPerDamage;
                            damage = (float)value;
                        }
                        health = livingEntity.getHealth();
                    }
                    if (damage > 0.0f) {
                        boolean damaged;
                        if (!entity2.fireImmune()) {
                            entity2.igniteForTicks(MathUtils.clampToInt(value));
                        }
                        int totemTimesUsed = -1;
                        if (entity2 instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)entity2;
                            MinecraftServer server = entity2.getServer();
                            if (server != null && server.isHardcore()) {
                                totemTimesUsed = player.getStats().getValue(Stats.ITEM_USED.get((Object)Items.TOTEM_OF_UNDYING));
                            }
                        }
                        if (damaged = entity2.hurt(MekanismDamageTypes.LASER.source(level), damage)) {
                            if (entity2 instanceof LivingEntity) {
                                LivingEntity livingEntity = (LivingEntity)entity2;
                                damage = Math.min(damage, Math.max(0.0f, health - livingEntity.getHealth()));
                                if (entity2 instanceof ServerPlayer) {
                                    ServerPlayer player = (ServerPlayer)entity2;
                                    boolean hardcoreTotem = totemTimesUsed != -1 && totemTimesUsed < player.getStats().getValue(Stats.ITEM_USED.get((Object)Items.TOTEM_OF_UNDYING));
                                    ((MekanismDamageTrigger)((Object)MekanismCriteriaTriggers.DAMAGE.value())).trigger(player, MekanismDamageTypes.LASER, hardcoreTotem);
                                }
                            }
                            if ((remainingEnergy -= MathUtils.clampToLong((float)energyPerDamage * damage)) == 0L) {
                                to = from.adjustPosition(direction, entity2);
                                break;
                            }
                            updateEnergyScale = true;
                        }
                    }
                    if (!updateEnergyScale || !((double)(laserEnergyScale - (energyScale = this.getEnergyScale(remainingEnergy))) > 0.01)) continue;
                    Pos3D entityPos = from.adjustPosition(direction, entity2);
                    this.sendLaserDataToPlayers(new LaserParticleData(direction, entityPos.distance(from), laserEnergyScale), from);
                    laserEnergyScale = energyScale;
                    from = entityPos;
                    adjustedAABB = this.getLaserBox(direction, from, to, laserEnergyScale);
                }
            }
            this.sendLaserDataToPlayers(new LaserParticleData(direction, to.distance(from), laserEnergyScale), from);
            if (remainingEnergy == 0L || result.getType() == HitResult.Type.MISS) {
                this.digging = null;
                this.diggingProgress = 0L;
            } else {
                ILaserReceptor laserReceptor;
                BlockPos hitPos = result.getBlockPos();
                if (!hitPos.equals((Object)this.digging)) {
                    this.digging = result.getType() == HitResult.Type.MISS ? null : hitPos;
                    this.diggingProgress = 0L;
                }
                if ((laserReceptor = WorldUtils.getCapability(level, Capabilities.LASER_RECEPTOR, hitPos, result.getDirection())) != null && !laserReceptor.canLasersDig()) {
                    laserReceptor.receiveLaserEnergy(remainingEnergy);
                } else {
                    BlockState hitState = level.getBlockState(hitPos);
                    float hardness = hitState.getDestroySpeed((BlockGetter)level, hitPos);
                    if (hardness >= 0.0f) {
                        this.diggingProgress += remainingEnergy;
                        if ((float)this.diggingProgress >= hardness * (float)MekanismConfig.general.laserEnergyPerHardness.get()) {
                            if (MekanismConfig.general.aestheticWorldDamage.get()) {
                                this.withFakePlayer((ServerLevel)level, to.x(), to.y(), to.z(), hitPos, hitState, result.getDirection());
                            }
                            this.diggingProgress = 0L;
                        } else {
                            PacketUtils.sendToAllTracking(new PacketHitBlockEffect(result), this);
                        }
                    }
                }
            }
            this.energyContainer.extract(firing, Action.EXECUTE, AutomationType.INTERNAL);
        } else if (this.getActive()) {
            this.setActive(false);
            if (this.diggingProgress != 0L) {
                this.diggingProgress = 0L;
            }
            if (this.lastFired != 0L) {
                this.lastFired = 0L;
                sendUpdatePacket = true;
            }
        }
        return sendUpdatePacket;
    }

    private AABB getLaserBox(Direction direction, Vec3 from, Vec3 to, float energyScale) {
        AABB aabb = new AABB(from, to);
        double halfDiameter = energyScale / 2.0f;
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP -> aabb.inflate(halfDiameter, 0.0, halfDiameter);
            case Direction.NORTH, Direction.SOUTH -> aabb.inflate(halfDiameter, halfDiameter, 0.0);
            case Direction.WEST, Direction.EAST -> aabb.inflate(0.0, halfDiameter, halfDiameter);
        };
    }

    private void withFakePlayer(ServerLevel level, double x, double y, double z, BlockPos hitPos, BlockState hitState, Direction hitSide) {
        MekFakePlayer dummy = MekFakePlayer.setupFakePlayer(level, x, y, z);
        dummy.setEmulatingUUID(this.getOwnerUUID());
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent((Level)level, hitPos, hitState, (Player)dummy);
        if (!((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            if (hitState.getBlock() instanceof TntBlock && hitState.isFlammable((BlockGetter)level, hitPos, hitSide)) {
                hitState.onCaughtFire((Level)level, hitPos, hitSide, null);
                level.removeBlock(hitPos, false);
            } else {
                this.handleBreakBlock(hitState, level, hitPos, (Player)dummy, ItemAtomicDisassembler.fullyChargedStack());
            }
        }
        dummy.cleanupFakePlayer(level);
    }

    private float damageShield(Level level, LivingEntity livingEntity, Pos3D from, float damage) {
        DamageSource source = MekanismDamageTypes.LASER.source(level, (Vec3)from);
        DamageContainer damageContainer = new DamageContainer(source, damage);
        LivingShieldBlockEvent event = CommonHooks.onDamageBlock((LivingEntity)livingEntity, (DamageContainer)damageContainer, (boolean)livingEntity.isDamageSourceBlocked(source));
        if (event.isCanceled() || !event.getBlocked()) {
            return 0.0f;
        }
        float shieldDamage = event.shieldDamage();
        if (shieldDamage > 0.0f) {
            livingEntity.hurtCurrentlyUsedShield(shieldDamage);
        }
        float damageBlocked = event.getBlockedDamage();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (damageBlocked > 0.0f && damageBlocked < 3.4028235E37f) {
                player.awardStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round(damageBlocked * 10.0f));
            }
        }
        return damageBlocked;
    }

    private float getEnergyScale(long energy) {
        return (float)Math.min((double)energy / (double)MekanismConfig.usage.laser.get() / 10.0, 0.6);
    }

    private void sendLaserDataToPlayers(LaserParticleData data, Vec3 from) {
        Object object;
        if (!this.isRemote() && (object = this.level) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)object;
            for (ServerPlayer player : serverWorld.players()) {
                serverWorld.sendParticles(player, (ParticleOptions)data, true, from.x, from.y, from.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void setEmittingRedstone(boolean foundEntity) {
    }

    protected boolean handleHitItem(ItemEntity entity) {
        return false;
    }

    protected void handleBreakBlock(BlockState state, ServerLevel level, BlockPos hitPos, Player player, ItemStack tool) {
        for (ItemEntity drop : WorldUtils.getDrops(state, level, hitPos, WorldUtils.getTileEntity((BlockGetter)level, hitPos), (Entity)player, tool, true)) {
            if (drop.getItem().isEmpty()) continue;
            level.addFreshEntity((Entity)drop);
        }
        this.breakBlock(state, level, hitPos, tool);
    }

    protected final void breakBlock(BlockState state, ServerLevel level, BlockPos hitPos, ItemStack tool) {
        state.spawnAfterBreak(level, hitPos, tool, false);
        level.removeBlock(hitPos, false);
        level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, hitPos, GameEvent.Context.of(null, (BlockState)state));
        level.levelEvent(2001, hitPos, Block.getId((BlockState)state));
    }

    protected long toFire() {
        return Long.MAX_VALUE;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        NBTUtils.setLegacyEnergyIfPresent(nbt, "last_fired", value -> {
            this.lastFired = value;
        });
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putLong("last_fired", this.lastFired);
    }

    @Override
    @Deprecated
    public void removeComponentsFromTag(@NotNull CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("last_fired");
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.putLong("last_fired", this.lastFired);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setLongIfPresent(tag, "last_fired", fired -> {
            this.lastFired = fired;
        });
    }

    public LaserEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }
}

