/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.gui;

import dev.shadowsoffire.hostilenetworks.HostileConfig;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.gui.DeepLearnerScreen;
import dev.shadowsoffire.hostilenetworks.gui.LootFabContainer;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.screen.PlaceboContainerScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class LootFabScreen
extends PlaceboContainerScreen<LootFabContainer> {
    public static final int WIDTH = 176;
    public static final int HEIGHT = 178;
    public static final ResourceLocation BASE = HostileNetworks.loc("textures/gui/loot_fabricator.png");
    public static final ResourceLocation PLAYER = HostileNetworks.loc("textures/gui/default_gui.png");
    public static final WidgetSprites LEFT_BUTTON = DeepLearnerScreen.makeSprites("widget/fab_left", "widget/fab_left_hovered");
    public static final WidgetSprites RIGHT_BUTTON = DeepLearnerScreen.makeSprites("widget/fab_right", "widget/fab_right_hovered");
    private DynamicHolder<DataModel> model = DataModelRegistry.INSTANCE.emptyHolder();
    private int currentPage = 0;
    private ImageButton btnLeft;
    private ImageButton btnRight;

    public LootFabScreen(LootFabContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageHeight = 178;
        this.imageWidth = 176;
    }

    public void render(GuiGraphics gfx, int pMouseX, int pMouseY, float pPartialTicks) {
        this.model = DataModelItem.getStoredModel(((LootFabContainer)this.menu).getSlot(0).getItem());
        if (this.model.isBound()) {
            this.btnLeft.visible = this.currentPage > 0;
            this.btnRight.visible = this.currentPage < ((DataModel)this.model.get()).fabDrops().size() / 9;
        } else {
            this.btnLeft.visible = false;
            this.btnRight.visible = false;
        }
        super.render(gfx, pMouseX, pMouseY, pPartialTicks);
    }

    public void init() {
        super.init();
        this.btnLeft = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.getGuiLeft() + 13, this.getGuiTop() + 68, 29, 12, LEFT_BUTTON, btn -> {
            if (this.model.isBound() && this.currentPage > 0) {
                --this.currentPage;
            }
        }));
        this.btnRight = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.getGuiLeft() + 46, this.getGuiTop() + 68, 29, 12, RIGHT_BUTTON, btn -> {
            if (this.model.isBound() && this.currentPage < ((DataModel)this.model.get()).fabDrops().size() / 9) {
                ++this.currentPage;
            }
        }));
    }

    protected void renderLabels(GuiGraphics gfx, int pX, int pY) {
    }

    protected void renderTooltip(GuiGraphics gfx, int pX, int pY) {
        if (this.isHovering(6, 10, 7, 53, pX, pY)) {
            ArrayList<MutableComponent> txt = new ArrayList<MutableComponent>(2);
            txt.add(Component.translatable((String)"hostilenetworks.gui.energy", (Object[])new Object[]{((LootFabContainer)this.menu).getEnergyStored(), HostileConfig.fabPowerCap}));
            txt.add(Component.translatable((String)"hostilenetworks.gui.fab_cost", (Object[])new Object[]{HostileConfig.fabPowerCost}));
            gfx.renderComponentTooltip(this.font, txt, pX, pY);
        }
        if (this.model.isBound()) {
            int selection = ((LootFabContainer)this.menu).getSelectedDrop((DataModel)this.model.get());
            if (selection != -1 && this.isHovering(79, 5, 16, 16, pX, pY)) {
                gfx.renderComponentTooltip(this.font, Arrays.asList(Component.translatable((String)"hostilenetworks.gui.clear")), pX, pY);
            }
            List<ItemStack> drops = ((DataModel)this.model.get()).fabDrops();
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    if (y * 3 + x >= Math.min(drops.size() - this.currentPage * 9, 9) || !this.isHovering(18 + 18 * x, 10 + 18 * y, 16, 16, pX, pY)) continue;
                    this.drawOnLeft(gfx, LootFabScreen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)drops.get(this.currentPage * 9 + y * 3 + x)), this.getGuiTop() + 15);
                }
            }
        }
        super.renderTooltip(gfx, pX, pY);
    }

    public boolean mouseClicked(double pX, double pY, int pButton) {
        if (this.model.isBound()) {
            List<ItemStack> drops = ((DataModel)this.model.get()).fabDrops();
            int selection = ((LootFabContainer)this.menu).getSelectedDrop((DataModel)this.model.get());
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    if (y * 3 + x >= drops.size() || !this.isHovering(18 + 18 * x, 10 + 18 * y, 16, 16, pX, pY) || selection == y * 3 + x) continue;
                    Minecraft.getInstance().gameMode.handleInventoryButtonClick(((LootFabContainer)this.menu).containerId, this.currentPage * 9 + y * 3 + x);
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                }
            }
            if (selection != -1 && this.isHovering(79, 5, 16, 16, pX, pY)) {
                Minecraft.getInstance().gameMode.handleInventoryButtonClick(((LootFabContainer)this.menu).containerId, -1);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        }
        return super.mouseClicked(pX, pY, pButton);
    }

    protected void renderBg(GuiGraphics gfx, float pPartialTicks, int pX, int pY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        gfx.blit(BASE, left, top, 0.0f, 0.0f, 176, 83, 256, 256);
        int energyHeight = Mth.floor((float)(53.0f * (float)((LootFabContainer)this.menu).getEnergyStored() / (float)HostileConfig.fabPowerCap));
        gfx.blit(BASE, left + 6, top + 10 + 53 - energyHeight, 0.0f, 83.0f, 7, energyHeight, 256, 256);
        int progHeight = Mth.floor((float)(35.0f * (float)((LootFabContainer)this.menu).getRuntime() / 60.0f));
        gfx.blit(BASE, left + 84, top + 23 + 35 - progHeight, 7.0f, 83.0f, 6, progHeight, 256, 256);
        gfx.blit(PLAYER, left, top + 88, 0.0f, 0.0f, 176, 90, 256, 256);
        if (this.model.isBound()) {
            int x;
            List<ItemStack> drops = ((DataModel)this.model.get()).fabDrops();
            for (int y = 0; y < 3; ++y) {
                for (x = 0; x < 3; ++x) {
                    if (y * 3 + x >= Math.min(drops.size() - this.currentPage * 9, 9) || !this.isHovering(18 + 18 * x, 10 + 18 * y, 16, 16, pX, pY)) continue;
                    gfx.blit(BASE, left + 16 + 19 * x, top + 8 + 19 * y, 13.0f, 83.0f, 18, 18, 256, 256);
                }
            }
            int selection = ((LootFabContainer)this.menu).getSelectedDrop((DataModel)this.model.get());
            if (selection != -1 && selection / 9 == this.currentPage) {
                int selIdx = selection - this.currentPage * 9;
                gfx.blit(BASE, left + 16 + 19 * (selIdx % 3), top + 8 + 19 * (selIdx / 3), 31.0f, 83.0f, 18, 18, 256, 256);
            }
            if (selection != -1) {
                gfx.renderItem(drops.get(selection), left + 79, top + 5);
                gfx.renderItemDecorations(this.font, drops.get(selection), left + 79 - 1, top + 5 - 1);
            }
            left += 17;
            top += 9;
            x = 0;
            int y = 0;
            for (int i = 0; i < Math.min(drops.size() - this.currentPage * 9, 9); ++i) {
                gfx.renderItem(drops.get(i + this.currentPage * 9), left + x * 19, top + y * 19);
                gfx.renderItemDecorations(this.font, drops.get(i + this.currentPage * 9), left + x * 19 - 1, top + y * 19 - 1);
                if (++x != 3) continue;
                ++y;
                x = 0;
            }
        }
    }

    public void drawOnLeft(GuiGraphics gfx, List<Component> list, int y) {
        if (list.isEmpty()) {
            return;
        }
        int xPos = this.getGuiLeft() - 16 - list.stream().map(arg_0 -> ((Font)this.font).width(arg_0)).max(Integer::compare).get();
        int maxWidth = 9999;
        if (xPos < 0) {
            maxWidth = this.getGuiLeft() - 6;
            xPos = -8;
        }
        ArrayList split = new ArrayList();
        int lambdastupid = maxWidth;
        list.forEach(comp -> split.addAll(this.font.getSplitter().splitLines((FormattedText)comp, lambdastupid, comp.getStyle())));
        gfx.renderComponentTooltip(this.font, split, xPos, y, ItemStack.EMPTY);
    }
}

