/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class LecternPocketModel {
    public static final ResourceLocation TEXTURE_NORMAL = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"entity/pocket_computer_normal");
    public static final ResourceLocation TEXTURE_ADVANCED = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"entity/pocket_computer_advanced");
    public static final ResourceLocation TEXTURE_COLOUR = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"entity/pocket_computer_colour");
    public static final ResourceLocation TEXTURE_FRAME = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"entity/pocket_computer_frame");
    public static final ResourceLocation TEXTURE_LIGHT = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"entity/pocket_computer_light");
    private static final Material MATERIAL_NORMAL = new Material(InventoryMenu.BLOCK_ATLAS, TEXTURE_NORMAL);
    private static final Material MATERIAL_ADVANCED = new Material(InventoryMenu.BLOCK_ATLAS, TEXTURE_ADVANCED);
    private static final Material MATERIAL_COLOUR = new Material(InventoryMenu.BLOCK_ATLAS, TEXTURE_COLOUR);
    private static final Material MATERIAL_FRAME = new Material(InventoryMenu.BLOCK_ATLAS, TEXTURE_FRAME);
    private static final Material MATERIAL_LIGHT = new Material(InventoryMenu.BLOCK_ATLAS, TEXTURE_LIGHT);
    public static final float TERM_WIDTH = 0.375f;
    public static final float TERM_HEIGHT = 0.4375f;
    private static final int TEXTURE_WIDTH = 24;
    private static final int TEXTURE_HEIGHT = 24;
    private final ModelPart root = LecternPocketModel.buildPages();

    private static ModelPart buildPages() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        parts.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -5.0f, -4.0f, 1.0f, 10.0f, 8.0f), PartPose.ZERO);
        return mesh.getRoot().bake(24, 24);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, ComputerFamily family, int frameColour, int lightColour) {
        if (frameColour != -1) {
            this.root.render(poseStack, MATERIAL_FRAME.buffer(bufferSource, RenderType::entityCutout), packedLight, packedOverlay);
            this.root.render(poseStack, MATERIAL_COLOUR.buffer(bufferSource, RenderType::entityCutout), packedLight, packedOverlay, frameColour);
        } else {
            VertexConsumer buffer = (family == ComputerFamily.ADVANCED ? MATERIAL_ADVANCED : MATERIAL_NORMAL).buffer(bufferSource, RenderType::entityCutout);
            this.root.render(poseStack, buffer, packedLight, packedOverlay);
        }
        this.root.render(poseStack, MATERIAL_LIGHT.buffer(bufferSource, RenderType::entityCutout), 0xF000F0, packedOverlay, lightColour);
    }
}

