/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.redstone;

import com.mojang.serialization.MapCodec;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import dan200.computercraft.shared.peripheral.redstone.RedstoneRelayBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public final class RedstoneRelayBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
IBundledRedstoneBlock {
    private static final MapCodec<RedstoneRelayBlock> CODEC = RedstoneRelayBlock.simpleCodec(RedstoneRelayBlock::new);

    public RedstoneRelayBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> properties) {
        properties.add(new Property[]{FACING});
    }

    protected MapCodec<RedstoneRelayBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext placement) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)placement.getHorizontalDirection());
    }

    @Deprecated
    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneRelayBlockEntity) {
            RedstoneRelayBlockEntity relay = (RedstoneRelayBlockEntity)blockEntity;
            relay.update();
        }
    }

    @Deprecated
    public boolean isSignalSource(BlockState state) {
        return true;
    }

    @Deprecated
    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction incomingSide) {
        int n;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneRelayBlockEntity) {
            RedstoneRelayBlockEntity relay = (RedstoneRelayBlockEntity)blockEntity;
            n = relay.getRedstoneOutput(incomingSide.getOpposite());
        } else {
            n = 0;
        }
        return n;
    }

    @Deprecated
    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getDirectSignal(state, level, pos, direction);
    }

    @Override
    public int getBundledRedstoneOutput(Level level, BlockPos pos, Direction side) {
        int n;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneRelayBlockEntity) {
            RedstoneRelayBlockEntity relay = (RedstoneRelayBlockEntity)blockEntity;
            n = relay.getBundledRedstoneOutput(side);
        } else {
            n = 0;
        }
        return n;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbour) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneRelayBlockEntity) {
            RedstoneRelayBlockEntity relay = (RedstoneRelayBlockEntity)blockEntity;
            relay.neighborChanged(neighbour);
        }
    }

    @Deprecated
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighbourBlock, BlockPos neighbourPos, boolean isMoving) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneRelayBlockEntity) {
            RedstoneRelayBlockEntity relay = (RedstoneRelayBlockEntity)blockEntity;
            relay.neighborChanged(neighbourPos);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RedstoneRelayBlockEntity(pos, state);
    }
}

