/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.gui.layers;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.ring.LeafyRingItem;
import it.hurts.sskirillss.relics.utils.Easing;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import it.hurts.sskirillss.relics.utils.data.SpriteMirror;
import java.awt.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;

public class LeafyRingHideLayer
implements LayeredDraw.Layer {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/leafy_ring_hide.png");
    private static final ResourceLocation VIGNETTE = ResourceLocation.withDefaultNamespace((String)"textures/misc/vignette.png");

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft MC = Minecraft.getInstance();
        LocalPlayer player = MC.player;
        if (player == null) {
            return;
        }
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.LEAFY_RING.get());
        Item item = stack.getItem();
        if (!(item instanceof LeafyRingItem)) {
            return;
        }
        LeafyRingItem relic = (LeafyRingItem)item;
        int progress = relic.getCurrentProgress(stack);
        if (progress <= 0) {
            return;
        }
        int maxProgress = relic.getMaxProgress();
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(false);
        float progressRatio = Easing.easeOutQuad(Math.min(1.0f, ((float)progress + partialTick * (float)(relic.isHiding(stack) ? 1 : -1)) / (float)maxProgress));
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        Window window = MC.getWindow();
        int width = window.getGuiScaledWidth();
        int height = window.getGuiScaledHeight();
        int texWidth = 89;
        int texHeight = 62;
        float alpha = progressRatio * 0.75f;
        float offsetX = (float)texWidth * (1.0f - progressRatio);
        float offsetY = (float)texHeight * (1.0f - progressRatio);
        Color color = new Color(BiomeColors.getAverageGrassColor((BlockAndTintGetter)player.level(), (BlockPos)player.blockPosition())).brighter();
        RenderSystem.enableBlend();
        GUIRenderer.begin(VIGNETTE, poseStack).anchor(SpriteAnchor.TOP_LEFT).patternSize(width, height).texSize(width, height).color(color).alpha(alpha * 0.25f).end();
        GUIRenderer.begin(TEXTURE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(-offsetX, -offsetY).color(color).alpha(alpha).scale(2.0f).end();
        GUIRenderer.begin(TEXTURE, poseStack).pos((float)width + offsetX, -offsetY).mirror(SpriteMirror.HORIZONTAL).anchor(SpriteAnchor.TOP_RIGHT).color(color).alpha(alpha).scale(2.0f).end();
        GUIRenderer.begin(TEXTURE, poseStack).pos(-offsetX, (float)height + offsetY).anchor(SpriteAnchor.BOTTOM_LEFT).mirror(SpriteMirror.VERTICAL).color(color).alpha(alpha).scale(2.0f).end();
        GUIRenderer.begin(TEXTURE, poseStack).pos((float)width + offsetX, (float)height + offsetY).mirror(SpriteMirror.HORIZONTAL, SpriteMirror.VERTICAL).anchor(SpriteAnchor.BOTTOM_RIGHT).color(color).alpha(alpha).scale(2.0f).end();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }
}

