/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks.lamps;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.EnumMap;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.world.content.blocks.SidedLightSourceBlock;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

@EventBusSubscriber(modid="xycraft_world", bus=EventBusSubscriber.Bus.MOD)
public class LampFlushBlock
extends SidedLightSourceBlock {
    private static final Reference2ObjectMap<Direction, VoxelShape> _shapeCache = LampFlushBlock.cacheShape(Shapes.empty(), MountShape);
    private static final Reference2ObjectMap<Direction, VoxelShape> _shapeCacheXL = LampFlushBlock.cacheShape(Shapes.empty(), MountShapeXl);

    public LampFlushBlock(IColorSource color, BlockBehaviour.Properties properties) {
        super(color, properties);
    }

    @NotNull
    public InteractionResult onWrenchUsed(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hit) {
        level.setBlock(pos, (BlockState)state.cycle((Property)SidedLightSourceBlock.StateProperties.Xl), 8);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        EnumMap<DyeColors, BlockContent> map = WorldContent.Block.LampFlush;
        Block[] lamps = (Block[])map.values().stream().map(BlockContent::block).toArray(Block[]::new);
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, (level, pos, ignored1, ignored2, ignored13) -> (player, interactionHand, hitResult) -> {
            BlockState state = level.getBlockState(pos);
            level.setBlock(pos, (BlockState)state.cycle((Property)SidedLightSourceBlock.StateProperties.Xl), 8);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }, lamps);
        event.registerBlock(CoreCapabilities.Colorable.BLOCK, LampFlushBlock.coloredLampProvider(map), lamps);
    }

    public VoxelShape getDownShapeForBaking() {
        return MountShape;
    }

    @Override
    public EnumSet<Direction> getValidMountDirections() {
        return EnumSet.allOf(Direction.class);
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (VoxelShape)((Boolean)state.getValue((Property)SidedLightSourceBlock.StateProperties.Xl) != false ? _shapeCacheXL : _shapeCache).get((Object)SidePartBlock.directionOf((BlockState)state));
    }

    @Override
    protected EnumMap<DyeColors, BlockContent> getCurrentMap(int light, BlockState state) {
        return WorldContent.Block.LampFlush;
    }
}

