/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.datagen;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public class WorldBlockLoot
extends BlockLootSubProvider {
    public static LootTableProvider supplier(PackOutput output, CompletableFuture<HolderLookup.Provider> future) {
        return new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(WorldBlockLoot::new, LootContextParamSets.BLOCK)), future);
    }

    protected WorldBlockLoot(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        WorldContent.Block.XychoriumOreStone.forEach((customColors, blockContent) -> this.add(blockContent.block(), block -> this.xyOreDrop((HolderLookup.RegistryLookup<Enchantment>)registrylookup, (XyCraftColors)customColors, (Block)block)));
        WorldContent.Block.XychoriumOreDeepslate.forEach((customColors, blockContent) -> this.add(blockContent.block(), block -> this.xyOreDrop((HolderLookup.RegistryLookup<Enchantment>)registrylookup, (XyCraftColors)customColors, (Block)block)));
        WorldContent.Block.XychoriumOreKivi.forEach((customColors, blockContent) -> this.add(blockContent.block(), block -> this.xyOreDrop((HolderLookup.RegistryLookup<Enchantment>)registrylookup, (XyCraftColors)customColors, (Block)block)));
        this.add(WorldContent.Block.AluminumOreStone.block(), this.createOreDrop(WorldContent.Block.AluminumOreStone.block(), WorldContent.Item.RawAluminum.item()));
        this.add(WorldContent.Block.AluminumOreDeepslate.block(), this.createOreDrop(WorldContent.Block.AluminumOreDeepslate.block(), WorldContent.Item.RawAluminum.item()));
        this.add(WorldContent.Block.AluminumOreKivi.block(), this.createOreDrop(WorldContent.Block.AluminumOreKivi.block(), WorldContent.Item.RawAluminum.item()));
        WorldContent.Block.GlassViewerRgb.forEach((dyeColor, blockContent) -> this.dropOther(blockContent.block(), (ItemLike)WorldContent.Block.GlassViewerRgb.get(DyeColors.White).block()));
        WorldContent.Block.GlassViewerRgbGlowing.forEach((dyeColor, blockContent) -> this.dropOther(blockContent.block(), (ItemLike)WorldContent.Block.GlassViewerRgbGlowing.get(DyeColors.White).block()));
        WorldContent.Block.AureyBlockMatte.forEach((dyeColor, blockContent) -> this.dropOther(blockContent.block(), (ItemLike)WorldContent.Block.AureyBlockMatte.get(DyeColors.Pink).block()));
        WorldContent.Block.AureyBlockMatteGlowing.forEach((dyeColor, blockContent) -> this.dropOther(blockContent.block(), (ItemLike)WorldContent.Block.AureyBlockMatteGlowing.get(DyeColors.Pink).block()));
        WorldContent.Block.AureyBlockFx.forEach((dyeColor, blockContent) -> this.dropOther(blockContent.block(), (ItemLike)WorldContent.Block.AureyBlockMatte.get(DyeColors.Pink).block()));
        WorldContent.Block.AureyBlockFxGlowing.forEach((dyeColor, blockContent) -> this.dropOther(blockContent.block(), (ItemLike)WorldContent.Block.AureyBlockMatteGlowing.get(DyeColors.Pink).block()));
        WorldContent.Block.LampRgbGlowing.forEach((dyeColor, blockContent) -> this.dropOther(blockContent.block(), (ItemLike)WorldContent.Block.LampRgbGlowing.get(DyeColors.White).block()));
        WorldContent.Block.LampRgbGlowingInverted.forEach((dyeColor, blockContent) -> this.dropOther(blockContent.block(), (ItemLike)WorldContent.Block.LampRgbGlowingInverted.get(DyeColors.White).block()));
        WorldContent.Block.LampLantern.forEach((dyeColor, blockContent) -> this.dropOther(blockContent.block(), (ItemLike)WorldContent.Block.LampLantern.get(DyeColors.White).block()));
        WorldContent.Block.LampFlush.forEach((dyeColor, blockContent) -> this.dropOther(blockContent.block(), (ItemLike)WorldContent.Block.LampFlush.get(DyeColors.White).block()));
        WorldContent.Block.LampCube.forEach((dyeColor, blockContent) -> this.dropOther(blockContent.block(), (ItemLike)WorldContent.Block.LampCube.get(DyeColors.White).block()));
        WorldContent.Block.LampPillar.forEach((dyeColor, blockContent) -> this.dropOther(blockContent.block(), (ItemLike)WorldContent.Block.LampPillar.get(DyeColors.White).block()));
        this.dropOther(WorldContent.Block.CopperTorch.block(), (ItemLike)WorldContent.Block.CopperTorch.item());
        this.dropOther(WorldContent.Block.AluminumTorch.block(), (ItemLike)WorldContent.Block.AluminumTorch.item());
        this.add(WorldContent.Block.Geyser.block(), WorldBlockLoot.noDrop());
        WorldContent.Map.ListOfBlocks.stream().filter(Predicate.not(BlockContent::hasCustomBreakRules)).map(BlockContent::block).forEach(x$0 -> this.dropSelf((Block)x$0));
    }

    @NotNull
    private LootTable.Builder xyOreDrop(HolderLookup.RegistryLookup<Enchantment> lookup, XyCraftColors color, Block block) {
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)WorldContent.Item.XychoriumGem.get(color).item()).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)lookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return WorldContent.Map.ListOfBlocks.stream().map(BlockContent::block).collect(Collectors.toList());
    }
}

