/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.Extruder2ModuleMenu;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.compiled.CompiledExtruderModule1;
import me.desht.modularrouters.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;

public class CompiledExtruderModule2
extends CompiledExtruderModule1 {
    private final List<ItemStack> blockTemplate;
    private final boolean mimic = this.getAugmentCount((Supplier<Item>)ModItems.MIMIC_AUGMENT) > 0;

    public CompiledExtruderModule2(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        this.blockTemplate = new Extruder2ModuleMenu.TemplateHandler(stack, router).toTemplate(this.getRange());
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        boolean extend = this.shouldExtend(router);
        Level world = router.nonNullLevel();
        if (extend && this.distance < this.blockTemplate.size()) {
            if (!(this.blockTemplate.get(this.distance).getItem() instanceof BlockItem)) {
                router.getExtensionData().putInt("ExtruderDist" + String.valueOf(this.getAbsoluteFacing()), ++this.distance);
            } else {
                BlockPos placePos = router.getBlockPos().relative(this.getAbsoluteFacing(), this.distance + 1);
                BlockState state = ModBlocks.TEMPLATE_FRAME.get().defaultBlockState();
                if (BlockUtil.tryPlaceBlock(router, state, world, placePos)) {
                    world.getBlockEntity(placePos, ModBlockEntities.TEMPLATE_FRAME.get()).ifPresent(te -> {
                        te.setCamouflage(this.blockTemplate.get(this.distance), this.getAbsoluteFacing(), this.getRouterFacing());
                        te.setExtendedMimic(this.mimic);
                        if (this.mimic) {
                            world.updateNeighborsAt(placePos, state.getBlock());
                        }
                    });
                    router.playSound(null, placePos, state.getBlock().getSoundType(state, (LevelReader)world, placePos, null).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                    router.getExtensionData().putInt("ExtruderDist" + String.valueOf(this.getAbsoluteFacing()), ++this.distance);
                    this.tryPushEntities(router.getLevel(), placePos, this.getAbsoluteFacing());
                    return true;
                }
            }
        } else if (!extend && this.distance > 0) {
            BlockPos breakPos = router.getBlockPos().relative(this.getAbsoluteFacing(), this.distance);
            BlockState oldState = world.getBlockState(breakPos);
            router.getExtensionData().putInt("ExtruderDist" + String.valueOf(this.getAbsoluteFacing()), --this.distance);
            if (this.okToBreak(oldState)) {
                if (oldState.getBlock() == ModBlocks.TEMPLATE_FRAME.get()) {
                    world.removeBlock(breakPos, false);
                    router.playSound(null, breakPos, oldState.getBlock().getSoundType(oldState, (LevelReader)world, breakPos, null).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                }
                return true;
            }
        }
        return false;
    }

    private boolean okToBreak(BlockState state) {
        Block b = state.getBlock();
        return state.isAir() || b == ModBlocks.TEMPLATE_FRAME.get() || b instanceof LiquidBlock;
    }
}

