/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.util.CustomEntityPlaceEvent;
import me.desht.modularrouters.util.fake_player.RouterFakePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;

public class BlockUtil {
    public static BlockState tryPlaceAsBlock(ModularRouterBlockEntity router, ItemStack toPlace, Level world, BlockPos pos, Direction facing) {
        if (!(toPlace.getItem() instanceof BlockItem)) {
            return null;
        }
        BlockState currentState = world.getBlockState(pos);
        RouterFakePlayer fakePlayer = router.getFakePlayer();
        fakePlayer.setYRot(BlockUtil.getYawFromFacing(facing));
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, toPlace);
        BlockHitResult hitResult = new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), facing, pos, false);
        UseOnContext useCtx = new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, hitResult);
        if (!currentState.canBeReplaced(new BlockPlaceContext(useCtx))) {
            return null;
        }
        try {
            InteractionResult res = toPlace.useOn(useCtx);
            return res.indicateItemUse() ? world.getBlockState(pos) : null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static boolean tryPlaceBlock(ModularRouterBlockEntity router, BlockState newState, Level world, BlockPos pos) {
        if (!(world instanceof ServerLevel) || !world.getBlockState(pos).canBeReplaced()) {
            return false;
        }
        BlockSnapshot snap = BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)pos);
        CustomEntityPlaceEvent event = new CustomEntityPlaceEvent(snap, Blocks.AIR.defaultBlockState(), (Entity)router.getFakePlayer(), newState);
        NeoForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled() && world.setBlockAndUpdate(pos, newState);
    }

    public static boolean tryBreakBlock(ModularRouterBlockEntity router, Level world, BlockPos pos, Filter filter, ItemStack pickaxe, boolean matchByBlock) {
        Tiers tier;
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (state.isAir() || state.getDestroySpeed((BlockGetter)world, pos) < 0.0f || block instanceof LiquidBlock || matchByBlock && !filter.test(new ItemStack((ItemLike)block))) {
            return false;
        }
        RouterFakePlayer fakePlayer = router.getFakePlayer();
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, pickaxe);
        Item item = pickaxe.getItem();
        if (item instanceof TieredItem) {
            TieredItem t = (TieredItem)item;
            v0 = t.getTier();
        } else {
            v0 = tier = Tiers.STONE;
        }
        if (((Boolean)ConfigHolder.common.module.breakerHarvestLevelLimit.get()).booleanValue() && state.is(tier.getIncorrectBlocksForDrops())) {
            return false;
        }
        List allDrops = Block.getDrops((BlockState)world.getBlockState(pos), (ServerLevel)serverWorld, (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)fakePlayer, (ItemStack)pickaxe);
        Map<Boolean, List<ItemStack>> groups = allDrops.stream().collect(Collectors.partitioningBy(matchByBlock ? s -> true : filter));
        if (!matchByBlock && allDrops.isEmpty() && !filter.isEmpty() && filter.isWhiteList()) {
            return false;
        }
        return (allDrops.isEmpty() || !groups.get(true).isEmpty()) && fakePlayer.gameMode.destroyBlock(pos);
    }

    public static String getBlockName(Level w, BlockPos pos) {
        return w == null || !w.isLoaded(pos) ? "" : w.getBlockState(pos).getBlock().getDescriptionId();
    }

    private static float getYawFromFacing(Direction facing) {
        return switch (facing) {
            case Direction.WEST -> 90.0f;
            case Direction.NORTH -> 180.0f;
            case Direction.EAST -> 270.0f;
            default -> 0.0f;
        };
    }
}

