/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;

public record KnownServerRegistries(List<ResourceLocation> dimension, Map<ResourceLocation, AdvancementInfo> advancements) {
    public static KnownServerRegistries client;
    public static KnownServerRegistries server;
    public static StreamCodec<RegistryFriendlyByteBuf, KnownServerRegistries> STREAM_CODEC;

    public static KnownServerRegistries create(MinecraftServer server) {
        ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
        for (ServerLevel level : server.getAllLevels()) {
            dimensions.add(level.dimension().location());
        }
        dimensions.sort(null);
        ArrayList<AdvancementInfo> advancementList = new ArrayList<AdvancementInfo>();
        server.getAdvancements().getAllAdvancements().forEach(advancement -> advancement.value().display().ifPresent(display -> advancementList.add(new AdvancementInfo(advancement.id(), display.getTitle(), display.getIcon()))));
        advancementList.sort(Comparator.comparing(o -> o.id));
        Map map = advancementList.stream().collect(Collectors.toMap(info -> info.id, info -> info, (a, b) -> b, () -> new LinkedHashMap(advancementList.size())));
        return new KnownServerRegistries(dimensions, map);
    }

    static {
        STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), KnownServerRegistries::dimension, (StreamCodec)ByteBufCodecs.map(LinkedHashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, AdvancementInfo.STREAM_CODEC), KnownServerRegistries::advancements, KnownServerRegistries::new);
    }

    public record AdvancementInfo(ResourceLocation id, Component name, ItemStack icon) {
        public static StreamCodec<RegistryFriendlyByteBuf, AdvancementInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, AdvancementInfo::id, (StreamCodec)ComponentSerialization.STREAM_CODEC, AdvancementInfo::name, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, AdvancementInfo::icon, AdvancementInfo::new);
    }
}

